/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.tasks;

import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.xtf.XtfWriter;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class InterlisRepositoryCreator
extends DefaultTask {
    private Logger log = Logging.getLogger(((Object)((Object)this)).getClass());
    private TransferDescription tdRepository = null;
    private IoxWriter ioxWriter = null;
    private static final String ILI_TOPIC = "IliRepository09.RepositoryIndex";
    private static final String ILI_CLASS = "IliRepository09.RepositoryIndex.ModelMetadata";
    private static final String ILI_STRUCT_MODELNAME = "IliRepository09.ModelName_";
    private static final String BID = "b1";
    @Input
    public Object modelsDir = null;
    @OutputFile
    public Object dataFile = null;

    @TaskAction
    public void writeIliModelsFile() {
        if (this.modelsDir == null) {
            throw new IllegalArgumentException("modelsDir must not be null");
        }
        if (this.dataFile == null) {
            throw new IllegalArgumentException("dataFile must not be null");
        }
        try {
            this.createXmlFile(this.getProject().file(this.dataFile).getAbsolutePath(), this.getProject().file(this.modelsDir));
        }
        catch (Ili2cException | IoxException | IOException e) {
            e.printStackTrace();
            this.log.error("failed to create ilimodels.xml");
            this.log.error(e.getMessage());
            GradleException ge = new GradleException();
            throw ge;
        }
    }

    private void createXmlFile(String outputFileName, File modelsDir) throws Ili2cException, IoxException, IOException {
        this.tdRepository = this.getTransferDescriptionFromModelName("IliRepository09");
        File outputFile = new File(outputFileName);
        this.ioxWriter = new XtfWriter(outputFile, this.tdRepository);
        this.ioxWriter.write((IoxEvent)new StartTransferEvent("SOGIS-20190203", "", null));
        this.ioxWriter.write((IoxEvent)new StartBasketEvent(ILI_TOPIC, BID));
        String[] iliExt = new String[]{"ili"};
        SuffixFileFilter iliFilter = new SuffixFileFilter(iliExt, IOCase.INSENSITIVE);
        Iterator it = FileUtils.iterateFiles((File)modelsDir, (IOFileFilter)iliFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        int i = 1;
        while (it.hasNext()) {
            File file = (File)it.next();
            TransferDescription td = this.getTransferDescriptionFromFileName(file.getAbsolutePath());
            for (Model lastModel : td.getModelsFromLastFile()) {
                Iom_jObject iomObj = new Iom_jObject(ILI_CLASS, String.valueOf(i));
                iomObj.setattrvalue("Name", lastModel.getName());
                if (lastModel.getIliVersion().equalsIgnoreCase("1")) {
                    iomObj.setattrvalue("SchemaLanguage", "ili1");
                } else if (lastModel.getIliVersion().equalsIgnoreCase("2.2")) {
                    iomObj.setattrvalue("SchemaLanguage", "ili2_2");
                } else if (lastModel.getIliVersion().equalsIgnoreCase("2.3")) {
                    iomObj.setattrvalue("SchemaLanguage", "ili2_3");
                }
                String filePath = file.getAbsoluteFile().getParent().replace(modelsDir.getAbsolutePath() + FileSystems.getDefault().getSeparator(), "");
                iomObj.setattrvalue("File", filePath + "/" + file.getName());
                if (lastModel.getModelVersion() == null) {
                    iomObj.setattrvalue("Version", "2000-01-01");
                } else {
                    iomObj.setattrvalue("Version", lastModel.getModelVersion());
                }
                try {
                    iomObj.setattrvalue("Issuer", lastModel.getIssuer());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                String technicalContact = lastModel.getMetaValue("technicalContact");
                if (technicalContact != null) {
                    if (technicalContact.contains("@") && !technicalContact.startsWith("mailto")) {
                        iomObj.setattrvalue("technicalContact", "mailto:agi@bd.so.ch");
                    } else {
                        iomObj.setattrvalue("technicalContact", lastModel.getMetaValue("technicalContact"));
                    }
                } else {
                    iomObj.setattrvalue("technicalContact", "mailto:agi@bd.so.ch");
                }
                String furtherInformation = lastModel.getMetaValue("furtherInformation");
                if (furtherInformation != null && furtherInformation.startsWith("http")) {
                    iomObj.setattrvalue("furtherInformation", furtherInformation);
                }
                try (InputStream is = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                    String md5 = DigestUtils.md5Hex((InputStream)is);
                    iomObj.setattrvalue("md5", md5);
                }
                for (Model model : lastModel.getImporting()) {
                    Iom_jObject iomObjDependsOnModel = new Iom_jObject(ILI_STRUCT_MODELNAME, null);
                    iomObjDependsOnModel.setattrvalue("value", model.getName());
                    iomObj.addattrobj("dependsOnModel", (IomObject)iomObjDependsOnModel);
                }
                this.ioxWriter.write((IoxEvent)new ObjectEvent((IomObject)iomObj));
                ++i;
            }
        }
        this.ioxWriter.write((IoxEvent)new EndBasketEvent());
        this.ioxWriter.write((IoxEvent)new EndTransferEvent());
        this.ioxWriter.flush();
        this.ioxWriter.close();
    }

    private TransferDescription getTransferDescriptionFromModelName(String iliModelName) throws Ili2cException {
        IliManager manager = new IliManager();
        String[] repositories = new String[]{"http://models.interlis.ch/", "http://models.kkgeo.ch/", "http://models.geo.admin.ch/", "http://geo.so.ch/models"};
        manager.setRepositories(repositories);
        ArrayList<String> modelNames = new ArrayList<String>();
        modelNames.add(iliModelName);
        Configuration config = manager.getConfig(modelNames, 2.3);
        TransferDescription iliTd = Ili2c.runCompiler((Configuration)config);
        if (iliTd == null) {
            throw new IllegalArgumentException("INTERLIS compiler failed");
        }
        return iliTd;
    }

    private TransferDescription getTransferDescriptionFromFileName(String fileName) throws Ili2cException {
        IliManager manager = new IliManager();
        String[] repositories = new String[]{"./models/AGI/", "./src/test/data/models/AGI/", "http://models.interlis.ch/", "http://models.kkgeo.ch/", "http://models.geo.admin.ch/"};
        manager.setRepositories(repositories);
        ArrayList<String> ilifiles = new ArrayList<String>();
        ilifiles.add(fileName);
        Configuration config = manager.getConfigWithFiles(ilifiles);
        TransferDescription iliTd = Ili2c.runCompiler((Configuration)config);
        if (iliTd == null) {
            throw new IllegalArgumentException("INTERLIS compiler failed");
        }
        return iliTd;
    }
}

