/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks;

import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.tasks.IliRepositorizer;
import ch.so.agi.gretl.util.TaskUtil;
import ch.so.agi.oereb.OerebIconizer;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class OerebIconizerQgis3
extends DefaultTask {
    protected GretlLogger log;
    @Input
    public String sldUrl = null;
    @Input
    public String legendGraphicUrl = null;
    @Input
    public Connector database = null;
    @Input
    public String dbQTable = null;
    @Input
    public String typeCodeAttrName = null;
    @Input
    public String symbolAttrName = null;
    @Input
    @Optional
    public String legendTextAttrName = null;
    @Input
    @Optional
    public boolean useCommunalTypeCodes = false;

    @TaskAction
    public void createAndSaveSymbols() {
        this.log = LogEnvironment.getLogger(IliRepositorizer.class);
        if (this.sldUrl == null) {
            throw new IllegalArgumentException("sldUrl must not be null");
        }
        if (this.legendGraphicUrl == null) {
            throw new IllegalArgumentException("legendGraphicUrl must not be null");
        }
        if (this.database == null) {
            throw new IllegalArgumentException("database must not be null");
        }
        if (this.dbQTable == null) {
            throw new IllegalArgumentException("dbQTable must not be null");
        }
        if (this.typeCodeAttrName == null) {
            throw new IllegalArgumentException("typeCodeAttrName must not be null");
        }
        if (this.symbolAttrName == null) {
            throw new IllegalArgumentException("symbolAttrName must not be null");
        }
        try {
            OerebIconizer iconizer = new OerebIconizer();
            List legendEntries = iconizer.getSymbolsQgis3(this.sldUrl, this.legendGraphicUrl);
            int count = iconizer.updateSymbols(legendEntries, this.database.getDbUri(), this.database.getDbUser(), this.database.getDbPassword(), this.dbQTable, this.typeCodeAttrName, this.symbolAttrName, this.legendTextAttrName, this.useCommunalTypeCodes);
            this.log.info("Updated " + String.valueOf(count) + " record(s).");
        }
        catch (Exception e) {
            this.log.error("Exception in OerebIconizerQgis3 task.", e);
            GradleException ge = TaskUtil.toGradleException(e);
            throw ge;
        }
    }
}

