/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.steps;

import ch.ehi.basics.settings.Settings;
import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.api.TransferSet;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.AttributeNameMap;
import ch.so.agi.gretl.util.EmptyFileException;
import ch.so.agi.gretl.util.EmptyListException;
import ch.so.agi.gretl.util.FileStylingDefinition;
import ch.so.agi.gretl.util.GretlException;
import ch.so.agi.gretl.util.NotAllowedSqlExpressionException;
import ch.so.agi.gretl.util.SqlReader;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Db2DbStep {
    public static final String PREFIX = "ch.so.agi.gretl.steps.Db2DbStep";
    public static final String SETTING_BATCH_SIZE = "ch.so.agi.gretl.steps.Db2DbStep.batchSize";
    public static final String SETTING_FETCH_SIZE = "ch.so.agi.gretl.steps.Db2DbStep.fetchSize";
    private static GretlLogger log = LogEnvironment.getLogger(Db2DbStep.class);
    private String taskName;
    private int batchSize = 5000;
    private int fetchSize = 5000;

    public Db2DbStep() {
        this(null);
    }

    public Db2DbStep(String taskName) {
        if (taskName == null) {
            taskName = Db2DbStep.class.getSimpleName();
        } else {
            this.taskName = taskName;
        }
        log = LogEnvironment.getLogger(this.getClass());
    }

    public void processAllTransferSets(Connector sourceDb, Connector targetDb, List<TransferSet> transferSets) throws Exception {
        this.processAllTransferSets(sourceDb, targetDb, transferSets, new Settings(), new HashMap<String, String>());
    }

    public void processAllTransferSets(Connector sourceDb, Connector targetDb, List<TransferSet> transferSets, Settings settings, Map<String, String> params) throws Exception {
        String fetchSizeStr;
        this.assertValidTransferSets(transferSets);
        String batchSizeStr = settings.getValue(SETTING_BATCH_SIZE);
        if (batchSizeStr != null) {
            try {
                int newBatchSize = Integer.parseInt(batchSizeStr);
                if (newBatchSize > 0) {
                    this.batchSize = newBatchSize;
                }
            }
            catch (NumberFormatException newBatchSize) {
                // empty catch block
            }
        }
        if ((fetchSizeStr = settings.getValue(SETTING_FETCH_SIZE)) != null) {
            try {
                int newFetchSize = Integer.parseInt(fetchSizeStr);
                if (newFetchSize >= 0) {
                    this.fetchSize = newFetchSize;
                }
            }
            catch (NumberFormatException newFetchSize) {
                // empty catch block
            }
        }
        log.lifecycle(String.format("Start Db2DbStep(Name: %s SourceDb: %s TargetDb: %s Transfers: %s)", this.taskName, sourceDb, targetDb, transferSets));
        Connection sourceDbConnection = null;
        Connection targetDbConnection = null;
        ArrayList<String> rowCountStrings = new ArrayList<String>();
        try {
            sourceDbConnection = sourceDb.connect();
            targetDbConnection = targetDb.connect();
            for (TransferSet transferSet : transferSets) {
                if (!transferSet.getInputSqlFile().canRead()) {
                    throw new IllegalArgumentException("File" + transferSet.getInputSqlFile().getName() + " not found or not readable");
                }
                FileStylingDefinition.checkForUtf8(transferSet.getInputSqlFile());
                try {
                    FileStylingDefinition.checkForBOMInFile(transferSet.getInputSqlFile());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                int rowCount = this.processTransferSet(sourceDbConnection, targetDbConnection, transferSet, params);
                rowCountStrings.add(Integer.toString(rowCount));
            }
            sourceDbConnection.commit();
            targetDbConnection.commit();
            String rowCountList = String.join((CharSequence)",", rowCountStrings);
            log.lifecycle(String.format("Db2DbStep %s: Transfered all Transfersets. Number of Transfersets: %s, transfered rows: [%s]", this.taskName, rowCountStrings.size(), rowCountList));
        }
        catch (Exception e) {
            if (sourceDbConnection != null) {
                sourceDbConnection.rollback();
            }
            if (targetDbConnection != null) {
                targetDbConnection.rollback();
            }
            log.error("Exception while executing processAllTransferSets()", e);
            throw e;
        }
        finally {
            if (sourceDbConnection != null) {
                sourceDbConnection.close();
            }
            if (targetDbConnection != null) {
                targetDbConnection.close();
            }
        }
    }

    private int processTransferSet(Connection srcCon, Connection targetCon, TransferSet transferSet, Map<String, String> params) throws SQLException, IOException, EmptyFileException, NotAllowedSqlExpressionException {
        if (transferSet.deleteAllRows()) {
            this.deleteDestTableContents(targetCon, transferSet.getOutputQualifiedTableName());
        }
        String selectStatement = this.extractSingleStatement(transferSet.getInputSqlFile(), params);
        ResultSet rs = this.createResultSet(srcCon, selectStatement);
        PreparedStatement insertRowStatement = this.createInsertRowStatement(srcCon, targetCon, rs, transferSet);
        int columncount = rs.getMetaData().getColumnCount();
        int k = 0;
        while (rs.next()) {
            this.transferRow(rs, insertRowStatement, columncount);
            if (k % this.batchSize == 0) {
                insertRowStatement.executeBatch();
                insertRowStatement.clearBatch();
            }
            ++k;
        }
        insertRowStatement.executeBatch();
        log.debug("Transfer " + k + " rows and " + columncount + " columns to table " + transferSet.getOutputQualifiedTableName());
        return k;
    }

    private void transferRow(ResultSet rs, PreparedStatement insertRowStatement, int columncount) throws SQLException {
        for (int j = 1; j <= columncount; ++j) {
            insertRowStatement.setObject(j, rs.getObject(j));
        }
        insertRowStatement.addBatch();
    }

    private void deleteDestTableContents(Connection targetCon, String destTableName) throws SQLException {
        String sqltruncate = "DELETE FROM " + destTableName;
        try {
            PreparedStatement stmt = targetCon.prepareStatement(sqltruncate);
            stmt.execute();
            log.info("DELETE executed");
        }
        catch (SQLException e1) {
            log.error("DELETE FROM TABLE " + destTableName + " failed.", e1);
            throw e1;
        }
    }

    private ResultSet createResultSet(Connection srcCon, String sqlSelectStatement) throws SQLException {
        Statement SQLStatement = srcCon.createStatement();
        SQLStatement.setFetchSize(this.fetchSize);
        ResultSet rs = SQLStatement.executeQuery(sqlSelectStatement);
        return rs;
    }

    private PreparedStatement createInsertRowStatement(Connection srcCon, Connection targetCon, ResultSet rs, TransferSet tSet) {
        ResultSetMetaData meta = null;
        PreparedStatement insertRowStatement = null;
        try {
            meta = rs.getMetaData();
            String insertColNames = Db2DbStep.buildInsertColumnNames(meta, targetCon, tSet.getOutputQualifiedTableName());
            String valuesList = Db2DbStep.buildValuesList(meta, tSet);
            String sql = "INSERT INTO " + tSet.getOutputQualifiedTableName() + " (" + insertColNames + ") VALUES (" + valuesList + ")";
            insertRowStatement = targetCon.prepareStatement(sql);
            log.info(String.format(this.taskName + ": Sql insert statement: [%s]", sql));
        }
        catch (SQLException g) {
            throw new GretlException(g);
        }
        return insertRowStatement;
    }

    private static String buildValuesList(ResultSetMetaData meta, TransferSet tSet) {
        StringBuffer valuesList = new StringBuffer();
        try {
            for (int j = 1; j <= meta.getColumnCount(); ++j) {
                String colName;
                if (j > 1) {
                    valuesList.append(", ");
                }
                if (tSet.isGeoColumn(colName = meta.getColumnName(j))) {
                    String func = tSet.wrapWithGeoTransformFunction(colName, "?");
                    valuesList.append(func);
                    continue;
                }
                valuesList.append("?");
            }
        }
        catch (SQLException se) {
            throw new GretlException(se);
        }
        return valuesList.toString();
    }

    private static String buildInsertColumnNames(ResultSetMetaData sourceMeta, Connection targetCon, String targetTableName) {
        StringBuffer columnNames = new StringBuffer();
        AttributeNameMap colMap = AttributeNameMap.createAttributeNameMap(targetCon, targetTableName);
        try {
            for (int j = 1; j <= sourceMeta.getColumnCount(); ++j) {
                if (j > 1) {
                    columnNames.append(", ");
                }
                String srcColName = sourceMeta.getColumnName(j);
                String targetColName = colMap.getAttributeName(srcColName);
                columnNames.append(targetColName);
            }
        }
        catch (SQLException se) {
            throw new GretlException(se);
        }
        return columnNames.toString();
    }

    private String extractSingleStatement(File targetFile, Map<String, String> params) throws IOException {
        SqlReader reader = new SqlReader();
        String firstStmt = reader.readSqlStmt(targetFile, params);
        if (firstStmt == null) {
            log.info("Empty File. No Statement to execute!");
            throw new EmptyFileException("EmptyFile: " + targetFile.getName());
        }
        String secondStmt = reader.nextSqlStmt();
        if (secondStmt != null) {
            log.info("There is more then 1 Statement in the file!");
            throw new IOException("There is more then 1 Statement in the file");
        }
        reader.close();
        return firstStmt;
    }

    private void assertValidTransferSets(List<TransferSet> transferSets) throws EmptyListException {
        if (transferSets.size() == 0) {
            throw new EmptyListException();
        }
        for (TransferSet ts : transferSets) {
            if (ts.getInputSqlFile().canRead()) continue;
            throw new GretlException("Can not read input sql file at path: " + ts.getInputSqlFile().getPath());
        }
    }
}

