/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.util;

import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class SqlReader {
    private PushbackReader reader = null;
    private Map<String, String> params = null;
    private GretlLogger log = LogEnvironment.getLogger(SqlReader.class);

    public String readSqlStmt(File sqlfile) throws IOException {
        return this.readSqlStmt(sqlfile, null);
    }

    public String readSqlStmt(File sqlfile, Map<String, String> params) throws IOException {
        if (this.reader != null) {
            throw new IllegalStateException("readSqlStmt() must only be called for the first statement");
        }
        this.params = params;
        this.createPushbackReader(sqlfile);
        String ret = ch.ehi.sqlgen.SqlReader.readSqlStmt((PushbackReader)this.reader, params);
        if (ret == null) {
            this.close();
        }
        return ret;
    }

    private void createPushbackReader(File sqlfile) throws FileNotFoundException {
        FileInputStream sqlFileInputStream = new FileInputStream(sqlfile);
        InputStreamReader sqlFileReader = new InputStreamReader((InputStream)sqlFileInputStream, StandardCharsets.UTF_8);
        this.reader = new PushbackReader(sqlFileReader);
    }

    public String nextSqlStmt() throws IOException {
        if (this.reader == null) {
            return null;
        }
        String ret = ch.ehi.sqlgen.SqlReader.readSqlStmt((PushbackReader)this.reader, this.params);
        if (ret == null) {
            this.close();
        }
        return ret;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }
}

