/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2pg.PgMain;
import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.TaskUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public abstract class Ili2pgAbstractTask
extends DefaultTask {
    protected GretlLogger log;
    @Input
    public Connector database;
    @Input
    @Optional
    public String dbschema = null;
    @Input
    @Optional
    public String proxy = null;
    @Input
    @Optional
    public Integer proxyPort = null;
    @Input
    @Optional
    public String modeldir = null;
    @Input
    @Optional
    public String models = null;
    @Input
    @Optional
    public String dataset = null;
    @Input
    @Optional
    public String baskets = null;
    @Input
    @Optional
    public String topics = null;
    @InputFile
    @Optional
    public File preScript = null;
    @InputFile
    @Optional
    public File postScript = null;
    @Input
    @Optional
    public boolean deleteData = false;
    @OutputFile
    @Optional
    public Object logFile = null;
    @Input
    @Optional
    public boolean trace = false;
    @InputFile
    @Optional
    public File validConfigFile = null;
    @Input
    @Optional
    public boolean disableValidation = false;
    @Input
    @Optional
    public boolean disableAreaValidation = false;
    @Input
    @Optional
    public boolean forceTypeValidation = false;
    @Input
    @Optional
    public boolean strokeArcs = false;
    @Input
    @Optional
    public boolean skipPolygonBuilding = false;
    @Input
    @Optional
    public boolean skipGeometryErrors = false;
    @Input
    @Optional
    public boolean iligml20 = false;

    protected void run(int function, Config settings) {
        this.log = LogEnvironment.getLogger(Ili2pgAbstractTask.class);
        if (this.database == null) {
            throw new IllegalArgumentException("database must not be null");
        }
        settings.setFunction(function);
        String xtfFilename = settings.getXtffile();
        if (this.proxy != null) {
            settings.setValue("ch.interlis.ili2c.http_proxy_host", this.proxy);
        }
        if (this.proxyPort != null) {
            settings.setValue("ch.interlis.ili2c.http_proxy_port", this.proxyPort.toString());
        }
        if (this.dbschema != null) {
            settings.setDbschema(this.dbschema);
        }
        if (this.modeldir != null) {
            settings.setModeldir(this.modeldir);
        }
        if (this.models != null) {
            settings.setModels(this.models);
        }
        if (this.dataset != null) {
            settings.setDatasetName(this.dataset);
        }
        if (this.baskets != null) {
            settings.setBaskets(this.baskets);
        }
        if (this.topics != null) {
            settings.setTopics(this.topics);
        }
        if (this.preScript != null) {
            settings.setPreScript(this.getProject().file((Object)this.preScript).getPath());
        }
        if (this.postScript != null) {
            settings.setPostScript(this.getProject().file((Object)this.postScript).getPath());
        }
        if (this.deleteData) {
            settings.setDeleteMode("data");
        }
        if (this.logFile != null) {
            settings.setLogfile(this.getProject().file(this.logFile).getPath());
        }
        if (this.trace) {
            EhiLogger.getInstance().setTraceFilter(false);
        }
        if (this.validConfigFile != null) {
            settings.setValidConfigFile(this.getProject().file((Object)this.validConfigFile).getPath());
        }
        if (this.disableValidation) {
            settings.setValidation(false);
        }
        if (this.disableAreaValidation) {
            settings.setDisableAreaValidation(true);
        }
        if (this.forceTypeValidation) {
            settings.setOnlyMultiplicityReduction(true);
        }
        if (this.strokeArcs) {
            settings.setStrokeArcs("enable");
        }
        if (this.skipPolygonBuilding) {
            Ili2db.setSkipPolygonBuilding((Config)settings);
        }
        if (this.skipGeometryErrors) {
            settings.setSkipGeometryErrors(true);
        }
        if (this.iligml20) {
            settings.setTransferFileFormat("ILIGML20");
        }
        Connection conn = null;
        try {
            conn = this.database.connect();
            if (conn == null) {
                throw new IllegalArgumentException("connection must not be null");
            }
            settings.setJdbcConnection(conn);
            Ili2db.readSettingsFromDb((Config)settings);
            Ili2db.run((Config)settings, null);
            conn.commit();
            conn.close();
            conn = null;
        }
        catch (Exception e) {
            this.log.error("failed to run ili2pg", e);
            GradleException ge = TaskUtil.toGradleException(e);
            throw ge;
        }
        finally {
            EhiLogger.getInstance().setTraceFilter(true);
            if (conn != null) {
                try {
                    conn.rollback();
                    conn.close();
                }
                catch (SQLException e) {
                    this.log.error("failed to rollback/close", e);
                }
                conn = null;
            }
        }
    }

    protected Config createConfig() {
        Config settings = new Config();
        new PgMain().initConfig(settings);
        return settings;
    }
}

