/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks;

import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.steps.SqlExecutorStep;
import ch.so.agi.gretl.util.TaskUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class SqlExecutor
extends DefaultTask {
    private static GretlLogger log;
    @Input
    public Connector database;
    @Input
    public List<String> sqlFiles;
    @Input
    @Optional
    public Map<String, String> sqlParameters = null;

    @TaskAction
    public void executeSQLExecutor() {
        String taskName = this.getName();
        if (this.sqlFiles == null) {
            throw new GradleException("sqlFiles is null");
        }
        List<File> files = this.convertToFileList(this.sqlFiles);
        try {
            SqlExecutorStep step = new SqlExecutorStep(taskName);
            step.execute(this.database, files, this.sqlParameters);
            log.info("Task start");
        }
        catch (Exception e) {
            log.error("Exception in creating / invoking SqlExecutorStep.", e);
            GradleException ge = TaskUtil.toGradleException(e);
            throw ge;
        }
    }

    private List<File> convertToFileList(List<String> filePaths) {
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : filePaths) {
            if (filePath == null || filePath.length() == 0) {
                throw new IllegalArgumentException("Filepaths must not be null or empty");
            }
            File absolute = TaskUtil.createAbsolutePath(filePath, this.getProject());
            files.add(absolute);
        }
        return files;
    }

    static {
        LogEnvironment.initGradleIntegrated();
        log = LogEnvironment.getLogger(SqlExecutor.class);
    }
}

