/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ioxwkf.dbtools.Db2Shp;
import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.TaskUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class ShpExport
extends DefaultTask {
    protected GretlLogger log;
    @Input
    public Connector database;
    @InputFile
    public Object dataFile = null;
    @Input
    String tableName = null;
    @Input
    @Optional
    public String schemaName = null;
    @Input
    @Optional
    public String encoding = null;

    @TaskAction
    public void exportData() {
        this.log = LogEnvironment.getLogger(ShpExport.class);
        if (this.database == null) {
            throw new IllegalArgumentException("database must not be null");
        }
        if (this.tableName == null) {
            throw new IllegalArgumentException("tableName must not be null");
        }
        if (this.dataFile == null) {
            return;
        }
        Settings settings = new Settings();
        settings.setValue("ch.interlis.ioxwkf.dbtools.dbTable", this.tableName);
        if (this.schemaName != null) {
            settings.setValue("ch.interlis.ioxwkf.dbtools.dbSchema", this.schemaName);
        }
        if (this.encoding != null) {
            settings.setValue("ch.interlis.ioxwkf.shp.encoding", this.encoding);
        }
        File data = this.getProject().file(this.dataFile);
        Connection conn = null;
        try {
            conn = this.database.connect();
            if (conn == null) {
                throw new IllegalArgumentException("connection must not be null");
            }
            Db2Shp db2shp = new Db2Shp();
            db2shp.exportData(data, conn, settings);
            conn.commit();
            conn.close();
            conn = null;
        }
        catch (Exception e) {
            this.log.error("failed to run ShpExport", e);
            GradleException ge = TaskUtil.toGradleException(e);
            throw ge;
        }
        finally {
            if (conn != null) {
                try {
                    conn.rollback();
                    conn.close();
                }
                catch (SQLException e) {
                    this.log.error("failed to rollback/close", e);
                }
                conn = null;
            }
        }
    }
}

