/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks;

import ch.ehi.basics.settings.Settings;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.tasks.impl.AbstractValidatorTask;
import ch.so.agi.gretl.tasks.impl.CsvValidatorImpl;
import java.util.ArrayList;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;

public class CsvValidator
extends AbstractValidatorTask {
    private GretlLogger log;
    @Input
    @Optional
    public boolean firstLineIsHeader = true;
    @Input
    @Optional
    public Character valueDelimiter = null;
    @Input
    @Optional
    public Character valueSeparator = null;
    @Optional
    public String encoding = null;

    @TaskAction
    public void validate() {
        this.log = LogEnvironment.getLogger(CsvValidator.class);
        if (this.dataFiles == null || this.dataFiles.size() == 0) {
            return;
        }
        ArrayList<String> files = new ArrayList<String>();
        for (Object fileObj : this.dataFiles) {
            String fileName = this.getProject().file(fileObj).getPath();
            files.add(fileName);
        }
        Settings settings = new Settings();
        this.initSettings(settings);
        settings.setValue("ch.interlis.ioxwkf.dbtools.firstLine", this.firstLineIsHeader ? "header" : "data");
        if (this.valueDelimiter != null) {
            settings.setValue("ch.interlis.ioxwkf.dbtools.valueDelimiter", this.valueDelimiter.toString());
        }
        if (this.valueSeparator != null) {
            settings.setValue("ch.interlis.ioxwkf.dbtools.valueSeparator", this.valueSeparator.toString());
        }
        if (this.encoding != null) {
            settings.setValue("ch.interlis.iom_j.csv.encoding", this.encoding);
        }
        this.validationOk = new CsvValidatorImpl().validate(files.toArray(new String[files.size()]), settings);
        if (!this.validationOk && this.failOnError) {
            throw new TaskExecutionException((Task)this, (Throwable)new Exception("validation failed"));
        }
    }
}

