/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ioxwkf.dbtools.Db2Csv;
import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.TaskUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class CsvExport
extends DefaultTask {
    protected GretlLogger log;
    @Input
    public Connector database;
    @InputFile
    public Object dataFile = null;
    @Input
    String tableName = null;
    @Input
    @Optional
    public boolean firstLineIsHeader = true;
    @Input
    @Optional
    public Character valueDelimiter = null;
    @Input
    @Optional
    public Character valueSeparator = null;
    @Input
    @Optional
    public String schemaName = null;
    @Optional
    public String[] attributes = null;
    @Optional
    public String encoding = null;

    @TaskAction
    public void exportData() {
        this.log = LogEnvironment.getLogger(CsvExport.class);
        if (this.database == null) {
            throw new IllegalArgumentException("database must not be null");
        }
        if (this.tableName == null) {
            throw new IllegalArgumentException("tableName must not be null");
        }
        if (this.dataFile == null) {
            return;
        }
        Settings settings = new Settings();
        settings.setValue("ch.interlis.ioxwkf.dbtools.dbTable", this.tableName);
        settings.setValue("ch.interlis.ioxwkf.dbtools.firstLine", this.firstLineIsHeader ? "header" : "data");
        if (this.valueDelimiter != null) {
            settings.setValue("ch.interlis.ioxwkf.dbtools.valueDelimiter", this.valueDelimiter.toString());
        }
        if (this.valueSeparator != null) {
            settings.setValue("ch.interlis.ioxwkf.dbtools.valueSeparator", this.valueSeparator.toString());
        }
        if (this.schemaName != null) {
            settings.setValue("ch.interlis.ioxwkf.dbtools.dbSchema", this.schemaName);
        }
        if (this.encoding != null) {
            settings.setValue("ch.interlis.iom_j.csv.encoding", this.encoding);
        }
        File data = this.getProject().file(this.dataFile);
        Connection conn = null;
        try {
            conn = this.database.connect();
            if (conn == null) {
                throw new IllegalArgumentException("connection must not be null");
            }
            Db2Csv db2csv = new Db2Csv();
            if (this.attributes != null) {
                db2csv.setAttributes(this.attributes);
            }
            db2csv.exportData(data, conn, settings);
            conn.commit();
            conn.close();
            conn = null;
        }
        catch (Exception e) {
            this.log.error("failed to run CsvExport", e);
            GradleException ge = TaskUtil.toGradleException(e);
            throw ge;
        }
        finally {
            if (conn != null) {
                try {
                    conn.rollback();
                    conn.close();
                }
                catch (SQLException e) {
                    this.log.error("failed to rollback/close", e);
                }
                conn = null;
            }
        }
    }
}

