/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks;

import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.TaskUtil;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class Av2ch
extends DefaultTask {
    protected GretlLogger log;
    @Input
    public Object inputFile = null;
    @Input
    public Object outputFile = null;
    @Input
    @Optional
    public String language = "de";

    @TaskAction
    public void runTransformation() {
        this.log = LogEnvironment.getLogger(Av2ch.class);
        if (this.inputFile == null) {
            throw new IllegalArgumentException("inputFile must not be null");
        }
        if (this.outputFile == null) {
            throw new IllegalArgumentException("outputFile must not be null");
        }
        if (!this.language.equalsIgnoreCase("de") && !this.language.equalsIgnoreCase("it")) {
            throw new IllegalArgumentException("language '" + this.language + "' is not supported.");
        }
        String inputFileName = this.getProject().file(this.inputFile).getAbsolutePath();
        String outputPath = this.getProject().file(this.outputFile).getParent();
        String outputFileName = this.getProject().file(this.outputFile).getName();
        try {
            ch.so.agi.av.Av2ch av2ch = new ch.so.agi.av.Av2ch();
            av2ch.convert(inputFileName, outputPath, outputFileName, this.language);
        }
        catch (Exception e) {
            this.log.error("failed to run Av2ch", e);
            GradleException ge = TaskUtil.toGradleException(e);
            throw ge;
        }
    }
}

