/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.steps;

import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.SqlReader;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class PostgisRasterExportStep {
    private GretlLogger log = LogEnvironment.getLogger(PostgisRasterExportStep.class);

    public void execute(Connector database, File sqlFile, File dataFile, Map<String, String> params) throws Exception {
        Connection conn = null;
        this.log.lifecycle("Database string: " + database.toString());
        this.log.lifecycle("SQL file:" + sqlFile.getAbsolutePath());
        this.log.lifecycle("Data file: " + dataFile.getAbsolutePath());
        try {
            conn = database.connect();
            SqlReader reader = new SqlReader();
            String sqlStmt = reader.readSqlStmt(sqlFile, params);
            this.log.debug("SQL statement:" + sqlStmt);
            PreparedStatement pstmt = conn.prepareStatement(sqlStmt);
            ResultSet rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            for (int i = 1; i < numberOfColumns + 1; ++i) {
                String columnTypeName = rsmd.getColumnTypeName(i);
                if (!columnTypeName.equalsIgnoreCase("bytea")) continue;
                rs.next();
                InputStream is = rs.getBinaryStream(i);
                FileUtils.copyInputStreamToFile((InputStream)is, (File)dataFile);
                break;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

