/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.logging;

import ch.so.agi.gretl.logging.CoreJavaLogFactory;
import ch.so.agi.gretl.logging.GradleLogFactory;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.Level;
import ch.so.agi.gretl.logging.LogFactory;

public class LogEnvironment {
    private static LogFactory currentLogFactory = null;

    public static void setLogFactory(LogFactory factory) {
        currentLogFactory = factory;
    }

    public static void initGradleIntegrated() {
        if (currentLogFactory == null) {
            LogEnvironment.setLogFactory(new GradleLogFactory());
        }
    }

    public static void initStandalone() {
        LogEnvironment.initStandalone(Level.DEBUG);
    }

    public static void initStandalone(Level logLevel) {
        if (currentLogFactory == null) {
            LogEnvironment.setLogFactory(new CoreJavaLogFactory(logLevel));
        }
    }

    public static GretlLogger getLogger(Class logSource) {
        if (currentLogFactory == null) {
            try {
                if (Class.forName("org.gradle.api.logging.Logger") != null) {
                    // empty if block
                }
                LogEnvironment.setLogFactory(new GradleLogFactory());
            }
            catch (ClassNotFoundException e) {
                LogEnvironment.setLogFactory(new CoreJavaLogFactory(Level.DEBUG));
            }
        }
        if (logSource == null) {
            throw new IllegalArgumentException("The logSource must not be null");
        }
        return currentLogFactory.getLogger(logSource);
    }
}

