/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.util;

import ch.so.agi.gretl.util.GretlException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class FileStylingDefinition {
    private static final String stringBOM = "\ufeff";
    private static final String encoding = "UTF-8";

    private FileStylingDefinition() {
    }

    public static void checkForUtf8(File inputfile) throws Exception {
        if (inputfile.length() > 0L) {
            byte[] buffer = new byte[(int)inputfile.length()];
            int fileEnd = -1;
            FileInputStream sqlFileInputStream = new FileInputStream(inputfile);
            BufferedInputStream bufferedInputFileStream = new BufferedInputStream(sqlFileInputStream);
            CharsetDecoder decoder = FileStylingDefinition.createCharsetDecoder();
            int lineBytes = bufferedInputFileStream.read(buffer);
            while (lineBytes != fileEnd) {
                try {
                    decoder.decode(ByteBuffer.wrap(buffer));
                    lineBytes = bufferedInputFileStream.read(buffer);
                }
                catch (CharacterCodingException e) {
                    throw new GretlException("Wrong encoding (not UTF-8) detected in File " + inputfile.getAbsolutePath());
                }
            }
            bufferedInputFileStream.close();
        }
    }

    private static CharsetDecoder createCharsetDecoder() {
        Charset charset = Charset.forName(encoding);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.reset();
        return decoder;
    }

    public static void checkForBOMInFile(File inputfile) throws Exception {
        FileInputStream sqlFileInputStream = new FileInputStream(inputfile);
        BufferedReader bufferedInputFileStream = new BufferedReader(new InputStreamReader((InputStream)sqlFileInputStream, encoding));
        String line = bufferedInputFileStream.readLine();
        if (line.startsWith(stringBOM)) {
            bufferedInputFileStream.close();
            throw new GretlException("file with unallowed BOM", "File includes not allowed BOM");
        }
        bufferedInputFileStream.close();
    }
}

