/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.steps;

import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.EmptyFileException;
import ch.so.agi.gretl.util.FileStylingDefinition;
import ch.so.agi.gretl.util.GretlException;
import ch.so.agi.gretl.util.SqlReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class SqlExecutorStep {
    private GretlLogger log;
    private String taskName;

    public SqlExecutorStep() {
        this(null);
    }

    public SqlExecutorStep(String taskName) {
        if (taskName == null) {
            taskName = SqlExecutorStep.class.getSimpleName();
        } else {
            this.taskName = taskName;
        }
        this.log = LogEnvironment.getLogger(this.getClass());
    }

    public void execute(Connector trans, List<File> sqlfiles) throws Exception {
        this.execute(trans, sqlfiles, null);
    }

    public void execute(Connector trans, List<File> sqlfiles, Map<String, String> params) throws Exception {
        Connection db = null;
        this.log.lifecycle(this.taskName + ": Start SqlExecutor");
        this.checkIfConnectorIsNotNull(trans);
        this.assertValidFilePaths(sqlfiles);
        this.log.lifecycle(this.taskName + ": Given parameters DB-URL: " + trans.connect().getMetaData().getURL() + ", DB-User: " + trans.connect().getMetaData().getUserName() + ", Files: " + sqlfiles);
        this.logPathToInputSqlFiles(sqlfiles);
        try {
            db = trans.connect();
            this.checkIfNoExistingFileIsEmpty(sqlfiles);
            this.checkFilesExtensionsForSqlExtension(sqlfiles);
            this.checkFilesForUTF8WithoutBOM(sqlfiles);
            this.readSqlFiles(sqlfiles, db, params);
            db.commit();
            this.log.lifecycle(this.taskName + ": End SqlExecutor (successful)");
        }
        catch (Exception e) {
            if (db != null) {
                db.rollback();
            }
            throw e;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    private void checkIfConnectorIsNotNull(Connector trans) throws GretlException {
        if (trans == null) {
            throw new GretlException("no database", "Connector-String must not be null");
        }
    }

    private void assertValidFilePaths(List<File> sqlfiles) throws GretlException {
        if (sqlfiles == null || sqlfiles.size() == 0) {
            throw new GretlException("no file", "Inputfile list is null or empty");
        }
        for (File file : sqlfiles) {
            if (file.canRead()) continue;
            throw new GretlException("TYPE_FILE_NOT_READABLE", "Can not read sql file at path: " + file.getPath());
        }
    }

    private void logPathToInputSqlFiles(List<File> sqlfiles) {
        for (File inputfile : sqlfiles) {
            this.log.info(inputfile.getAbsolutePath());
        }
    }

    private void checkIfNoExistingFileIsEmpty(List<File> sqlfiles) throws Exception {
        for (File file : sqlfiles) {
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file.getAbsoluteFile()));
                if (br.readLine() != null) continue;
                throw new EmptyFileException("File must not be empty: " + file.getAbsolutePath());
            }
            throw new FileNotFoundException("File could not be found: " + file.getAbsolutePath());
        }
    }

    private void checkFilesExtensionsForSqlExtension(List<File> sqlfiles) throws Exception {
        for (File file : sqlfiles) {
            String fileExtension = FilenameUtils.getExtension((String)file.getAbsolutePath());
            if (fileExtension.equalsIgnoreCase("sql")) continue;
            throw new GretlException("no .sql-Extension", "File extension must be .sql. Error at File: " + file.getAbsolutePath());
        }
    }

    private void checkFilesForUTF8WithoutBOM(List<File> sqlfiles) throws Exception {
        for (File file : sqlfiles) {
            FileStylingDefinition.checkForUtf8(file);
            FileStylingDefinition.checkForBOMInFile(file);
        }
    }

    private void readSqlFiles(List<File> sqlfiles, Connection db, Map<String, String> params) throws Exception {
        for (File sqlfile : sqlfiles) {
            this.executeAllSqlStatements(db, sqlfile, params);
        }
    }

    private void executeAllSqlStatements(Connection conn, File sqlfile, Map<String, String> params) throws Exception {
        SqlReader reader = new SqlReader();
        String statement = reader.readSqlStmt(sqlfile, params);
        if (statement == null) {
            throw new GretlException("no statement in sql-file", "At least one statement must be in the sql-File");
        }
        while (statement != null) {
            this.prepareSqlStatement(conn, statement);
            statement = reader.nextSqlStmt();
        }
        reader.close();
    }

    private void prepareSqlStatement(Connection conn, String statement) throws Exception {
        if ((statement = statement.trim()).length() > 0) {
            this.log.debug(statement);
            Statement dbstmt = null;
            dbstmt = conn.createStatement();
            this.executeSqlStatement(dbstmt, statement);
        }
    }

    private void executeSqlStatement(Statement dbstmt, String statement) throws Exception {
        try {
            boolean isResultSet = dbstmt.execute(statement);
            if (isResultSet) {
                ResultSet rs = dbstmt.getResultSet();
                StringBuffer res = new StringBuffer();
                int colCount = rs.getMetaData().getColumnCount();
                String sep = "";
                while (rs.next()) {
                    for (int i = 1; i <= colCount; ++i) {
                        String value = rs.getString(i);
                        if (value == null) continue;
                        res.append(sep);
                        res.append(value);
                        sep = " ";
                    }
                    if (res.length() > 0) {
                        this.log.lifecycle(this.taskName + ": " + res.toString());
                    }
                    res.setLength(0);
                    sep = "";
                }
            } else {
                int modifiedLines = dbstmt.getUpdateCount();
                if (modifiedLines == 1) {
                    this.log.lifecycle(this.taskName + ": " + modifiedLines + " Line has been modified.");
                } else if (modifiedLines > 1) {
                    this.log.lifecycle(this.taskName + ": " + modifiedLines + " Lines have been modified.");
                } else if (modifiedLines < 1) {
                    this.log.lifecycle(this.taskName + ": No Line has been modified.");
                }
            }
        }
        catch (SQLException ex) {
            throw new SQLException("Error while executing the sqlstatement. " + ex.getMessage());
        }
        finally {
            dbstmt.close();
        }
    }
}

