/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.api;

import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.util.DbConnector;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;

public class Connector {
    private String dbUri;
    private String dbUser;
    private String dbPassword;
    private GretlLogger log;
    private Connection dbConnection = null;

    public Connector(String dbUri) {
        this(dbUri, null, null);
    }

    public Connector(String dbUri, String dbUser) {
        this(dbUri, dbUri, null);
    }

    public Connector(String dbUri, String dbUser, String dbPassword) {
        this.dbUri = dbUri;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        this.log = LogEnvironment.getLogger(this.getClass());
    }

    public Connection connect() throws SQLException {
        if (this.dbConnection == null) {
            this.dbConnection = DbConnector.connect(this.dbUri, this.dbUser, this.dbPassword);
            this.dbConnection.setAutoCommit(false);
        }
        return this.dbConnection;
    }

    public String toString() {
        int passLength = 0;
        if (this.dbPassword != null) {
            passLength = this.dbPassword.length();
        }
        char[] starArray = new char[passLength];
        Arrays.fill(starArray, "*".toCharArray()[0]);
        String res = String.format("Connection( DbUri: %s, DbUser: %s DbPass: %s)", this.dbUri, this.dbUser, new String(starArray));
        return res;
    }
}

