/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.util;

import ch.so.agi.gretl.util.GretlException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class AttributeNameMap {
    private Connection con;
    private String tableName;
    private HashMap<String, String> attributeNames;

    private AttributeNameMap(Connection con, String tableName) {
        this.con = con;
        this.tableName = tableName;
        this.attributeNames = new HashMap();
    }

    public static AttributeNameMap createAttributeNameMap(Connection con, String tableName) {
        AttributeNameMap map = new AttributeNameMap(con, tableName);
        map.initializeFromDbSchema();
        return map;
    }

    private void initializeFromDbSchema() {
        String sql = String.format("select * from %s where 0=1", this.tableName);
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String attrName = meta.getColumnName(i);
                this.attributeNames.put(attrName.toLowerCase(), attrName);
            }
        }
        catch (SQLException se) {
            throw new GretlException(se.getMessage(), se);
        }
    }

    public String getAttributeName(String nameInAnyCase) {
        String nameLower = nameInAnyCase.toLowerCase();
        String nameInExactCase = this.attributeNames.get(nameLower);
        if (nameInExactCase == null) {
            throw new GretlException("TYPE_COLUMN_MISMATCH", String.format("Requested attribute [%s] is not contained in this AttributeNameMap.", nameInAnyCase));
        }
        return nameInExactCase;
    }
}

