/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.gretl.tasks;

import ch.ehi.basics.settings.Settings;
import ch.so.agi.gretl.api.Connector;
import ch.so.agi.gretl.api.TransferSet;
import ch.so.agi.gretl.logging.GretlLogger;
import ch.so.agi.gretl.logging.LogEnvironment;
import ch.so.agi.gretl.steps.Db2DbStep;
import ch.so.agi.gretl.util.TaskUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class Db2Db
extends DefaultTask {
    private static GretlLogger log;
    @Input
    public Connector sourceDb;
    @Input
    public Connector targetDb;
    @Input
    public List<TransferSet> transferSets;
    @Input
    @Optional
    public Integer batchSize = null;
    @Input
    @Optional
    public Integer fetchSize = null;
    @Input
    @Optional
    public Map<String, String> sqlParameters = null;

    @TaskAction
    public void executeTask() throws Exception {
        String taskName = this.getName();
        this.convertToAbsolutePaths(this.transferSets);
        log.info(String.format("Start Db2DbTask(Name: %s SourceDb: %s TargetDb: %s Transfers: %s)", taskName, this.sourceDb, this.targetDb, this.transferSets));
        Settings settings = new Settings();
        if (this.batchSize != null) {
            settings.setValue("ch.so.agi.gretl.steps.Db2DbStep.batchSize", this.batchSize.toString());
        }
        if (this.fetchSize != null) {
            settings.setValue("ch.so.agi.gretl.steps.Db2DbStep.fetchSize", this.fetchSize.toString());
        }
        try {
            Db2DbStep step = new Db2DbStep(taskName);
            step.processAllTransferSets(this.sourceDb, this.targetDb, this.transferSets, settings, this.sqlParameters);
        }
        catch (Exception e) {
            log.error("Exception in creating / invoking Db2DbStep in Db2DbTask", e);
            GradleException gradleEx = TaskUtil.toGradleException(e);
            throw gradleEx;
        }
    }

    private void convertToAbsolutePaths(List<TransferSet> transferSets) {
        for (TransferSet ts : transferSets) {
            File configured = ts.getInputSqlFile();
            File absolutePath = TaskUtil.createAbsolutePath(configured, this.getProject());
            ts.setInputSqlFile(absolutePath);
        }
    }

    static {
        LogEnvironment.initGradleIntegrated();
        log = LogEnvironment.getLogger(Db2Db.class);
    }
}

