/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.camel;

import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2pg.PgMain;
import ch.so.agi.camel.Ili2pgEndpoint;
import java.io.File;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ili2pgProducer
extends DefaultProducer {
    private static final Logger log = LoggerFactory.getLogger(Ili2pgProducer.class);
    private Ili2pgEndpoint endpoint;
    private final String ILI2PG_HEADER_NAME = "ili2pg";

    public Ili2pgProducer(Ili2pgEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        File xtfFile = (File)exchange.getIn().getBody(File.class);
        Config settings = this.createConfig();
        if (this.endpoint.getOperation().equalsIgnoreCase("import")) {
            settings.setFunction(1);
        } else if (this.endpoint.getOperation().equalsIgnoreCase("schemaimport")) {
            settings.setFunction(2);
        } else if (this.endpoint.getOperation().equalsIgnoreCase("replace")) {
            settings.setFunction(6);
            if (this.endpoint.getDataset() == null) {
                throw new Exception("dataset must not be null");
            }
        }
        settings.setDbhost(this.endpoint.getDbhost());
        settings.setDbport(this.endpoint.getDbport());
        settings.setDbdatabase(this.endpoint.getDbdatabase());
        settings.setDbschema(this.endpoint.getDbschema());
        settings.setDbusr(this.endpoint.getDbusr());
        settings.setDbpwd(this.endpoint.getDbpwd());
        String dburl = "jdbc:postgresql://" + settings.getDbhost() + ":" + settings.getDbport() + "/" + settings.getDbdatabase();
        settings.setDburl(dburl);
        if (this.endpoint.isNameByTopic()) {
            settings.setNameOptimization("topic");
        }
        if (this.endpoint.getDisableValidation()) {
            settings.setValidation(false);
        }
        if (this.endpoint.getDataset() != null) {
            settings.setDatasetName(this.endpoint.getDataset());
        }
        if (this.endpoint.getModels() != null) {
            settings.setModels(this.endpoint.getModels());
        }
        if (Ili2db.isItfFilename((String)xtfFile.getAbsolutePath())) {
            settings.setItfTransferfile(true);
        }
        settings.setXtffile(xtfFile.getAbsolutePath());
        try {
            Ili2db.readSettingsFromDb((Config)settings);
            Ili2db.run((Config)settings, null);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getOut();
                out.copyFrom(exchange.getIn());
                out.setBody((Object)xtfFile);
            } else {
                Message in = exchange.getIn();
                in.setBody((Object)xtfFile);
            }
        }
        catch (Exception e) {
            log.error("failed to run ili2pg", (Throwable)e);
            log.error(e.getMessage());
            throw new Exception(e);
        }
    }

    private Config createConfig() {
        Config settings = new Config();
        new PgMain().initConfig(settings);
        return settings;
    }
}

