/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.camel.processors;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.interlis2.av2geobau.Av2geobau;

public class Av2GeobauProcessor
implements Processor {
    public void process(Exchange exchange) throws Exception {
        File itfFile = (File)exchange.getIn().getBody(File.class);
        Path tempDir = Files.createTempDirectory("av2geobau_", new FileAttribute[0]);
        File dxfFile = Paths.get(tempDir.toFile().getAbsolutePath(), itfFile.getName().replaceFirst("[.][^.]+$", "") + ".dxf").toFile();
        Settings settings = new Settings();
        settings.setValue("org.interlis2.av2geobau.ilidirs", "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels");
        EhiLogger.getInstance().setTraceFilter(false);
        boolean ok = Av2geobau.convert((File)itfFile, (File)dxfFile, (Settings)settings);
        if (!ok) {
            throw new Exception("could not convert: " + itfFile.getAbsolutePath());
        }
        exchange.getIn().setBody((Object)dxfFile);
    }
}

