/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.user;

import java.security.Principal;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;

public final class UserSessionWebSocketHandlerDecoratorFactory
implements WebSocketHandlerDecoratorFactory {
    private final UserSessionRegistry userSessionRegistry;

    public UserSessionWebSocketHandlerDecoratorFactory(UserSessionRegistry userSessionRegistry) {
        Assert.notNull((Object)userSessionRegistry, (String)"'userSessionRegistry' is required ");
        this.userSessionRegistry = userSessionRegistry;
    }

    public WebSocketHandler decorate(WebSocketHandler handler) {
        return new UserSessionWebSocketHandler(handler);
    }

    private final class UserSessionWebSocketHandler
    extends WebSocketHandlerDecorator {
        public UserSessionWebSocketHandler(WebSocketHandler delegate) {
            super(delegate);
        }

        public void afterConnectionEstablished(WebSocketSession webSocketSession) throws Exception {
            super.afterConnectionEstablished(webSocketSession);
            Principal principal = webSocketSession.getPrincipal();
            if (principal != null) {
                UserSessionWebSocketHandlerDecoratorFactory.this.userSessionRegistry.registerSessionId(principal.getName(), webSocketSession.getId());
            }
        }

        public void afterConnectionClosed(WebSocketSession webSocketSession, CloseStatus closeStatus) throws Exception {
            Principal principal = webSocketSession.getPrincipal();
            if (principal != null) {
                String userName = principal.getName();
                UserSessionWebSocketHandlerDecoratorFactory.this.userSessionRegistry.unregisterSessionId(userName, webSocketSession.getId());
            }
            super.afterConnectionClosed(webSocketSession, closeStatus);
        }
    }
}

