/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import ch.rasc.wampspring.message.WampMessage;
import java.security.Principal;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;

public class PrincipalMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return Principal.class.isAssignableFrom(paramType);
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Principal user = ((WampMessage)message).getPrincipal();
        if (user == null) {
            throw new MessageHandlingException(message, "No \"principal\" header in message");
        }
        return user;
    }
}

