/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import ch.rasc.wampspring.annotation.WampPublishListener;
import ch.rasc.wampspring.method.MethodParameterConverter;
import java.lang.annotation.Annotation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

public class PayloadArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String MVC_VALIDATOR_NAME = "mvcValidator";
    private final Validator validator;
    private final MethodParameterConverter methodParameterConverter;

    public PayloadArgumentResolver(ApplicationContext applicationContext, MethodParameterConverter methodParameterConverter) {
        this.methodParameterConverter = methodParameterConverter;
        if (applicationContext.containsBean(MVC_VALIDATOR_NAME)) {
            this.validator = (Validator)applicationContext.getBean(MVC_VALIDATOR_NAME, Validator.class);
        } else if (ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)this.getClass().getClassLoader())) {
            Class clazz;
            try {
                String className = "org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean";
                clazz = ClassUtils.forName((String)className, (ClassLoader)AbstractMessageBrokerConfiguration.class.getClassLoader());
            }
            catch (Throwable ex) {
                throw new BeanInitializationException("Could not find default validator class", ex);
            }
            this.validator = (Validator)BeanUtils.instantiate((Class)clazz);
        } else {
            this.validator = new Validator(){

                public boolean supports(Class<?> clazz) {
                    return false;
                }

                public void validate(Object target, Errors errors) {
                }
            };
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getMethod().getAnnotation(WampPublishListener.class) != null;
    }

    public Object resolveArgument(MethodParameter param, Message<?> message) throws Exception {
        Payload ann = (Payload)param.getParameterAnnotation(Payload.class);
        if (ann != null && StringUtils.hasText((String)ann.value())) {
            throw new IllegalStateException("@Payload SpEL expressions not supported by this resolver");
        }
        Object payload = message.getPayload();
        if (this.isEmptyPayload(payload)) {
            if (ann == null || ann.required()) {
                String paramName = PayloadArgumentResolver.getParameterName(param);
                BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(payload, paramName);
                bindingResult.addError(new ObjectError(paramName, "@Payload param is required"));
                throw new MethodArgumentNotValidException(message, param, (BindingResult)bindingResult);
            }
            return null;
        }
        Class targetClass = param.getParameterType();
        if (ClassUtils.isAssignable((Class)targetClass, payload.getClass())) {
            this.validate(message, param, payload);
            return payload;
        }
        payload = this.methodParameterConverter.convert(param, message.getPayload());
        if (payload == null) {
            throw new MessageConversionException(message, "No converter found to convert to " + targetClass + ", message=" + message);
        }
        this.validate(message, param, payload);
        return payload;
    }

    protected boolean isEmptyPayload(Object payload) {
        if (payload == null) {
            return true;
        }
        if (payload instanceof byte[]) {
            return ((byte[])payload).length == 0;
        }
        if (payload instanceof String) {
            return !StringUtils.hasText((String)((String)payload));
        }
        return false;
    }

    private static String getParameterName(MethodParameter param) {
        String paramName = param.getParameterName();
        return paramName != null ? paramName : "Arg " + param.getParameterIndex();
    }

    protected void validate(Message<?> message, MethodParameter parameter, Object target) {
        if (this.validator == null) {
            return;
        }
        for (Annotation ann : parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(target, PayloadArgumentResolver.getParameterName(parameter));
            if (!ObjectUtils.isEmpty((Object[])validationHints) && this.validator instanceof SmartValidator) {
                ((SmartValidator)this.validator).validate(target, (Errors)bindingResult, validationHints);
            } else {
                this.validator.validate(target, (Errors)bindingResult);
            }
            if (!bindingResult.hasErrors()) break;
            throw new MethodArgumentNotValidException(message, parameter, (BindingResult)bindingResult);
        }
    }
}

