/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.UsesJava8;

public class MethodParameterConverter {
    private final ObjectMapper objectMapper;
    private final ConversionService conversionService;

    public MethodParameterConverter(ObjectMapper objectMapper, ConversionService conversionService) {
        this.objectMapper = objectMapper;
        this.conversionService = conversionService;
    }

    public Object convert(MethodParameter parameter, Object argument) {
        if (argument == null) {
            if (parameter.getParameterType().getName().equals("java.util.Optional")) {
                return OptionalUnwrapper.empty();
            }
            return null;
        }
        Class<?> sourceClass = argument.getClass();
        Class targetClass = parameter.getParameterType();
        TypeDescriptor td = new TypeDescriptor(parameter);
        if (targetClass.isAssignableFrom(sourceClass)) {
            return this.convertListElements(td, argument);
        }
        if (this.conversionService.canConvert(sourceClass, targetClass)) {
            try {
                return this.convertListElements(td, this.conversionService.convert(argument, targetClass));
            }
            catch (Exception e) {
                TypeFactory typeFactory = this.objectMapper.getTypeFactory();
                if (td.isCollection()) {
                    CollectionType type = CollectionType.construct((Class)td.getType(), (JavaType)typeFactory.constructType((Type)td.getElementTypeDescriptor().getType()));
                    return this.objectMapper.convertValue(argument, (JavaType)type);
                }
                if (td.isArray()) {
                    ArrayType type = typeFactory.constructArrayType(td.getElementTypeDescriptor().getType());
                    return this.objectMapper.convertValue(argument, (JavaType)type);
                }
                throw e;
            }
        }
        return this.objectMapper.convertValue(argument, targetClass);
    }

    private Object convertListElements(TypeDescriptor td, Object convertedValue) {
        if (List.class.isAssignableFrom(convertedValue.getClass()) && td.isCollection() && td.getElementTypeDescriptor() != null) {
            Class elementType = td.getElementTypeDescriptor().getType();
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : (List)convertedValue) {
                Object convertedObject = this.objectMapper.convertValue(record, elementType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return convertedValue;
    }

    @UsesJava8
    private static class OptionalUnwrapper {
        private OptionalUnwrapper() {
        }

        public static Object empty() {
            return Optional.empty();
        }
    }
}

