/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import ch.rasc.wampspring.message.WampMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.AbstractMessageCondition;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

public class DestinationPatternsMessageCondition
extends AbstractMessageCondition<DestinationPatternsMessageCondition> {
    private final Set<String> patterns;
    private final PathMatcher pathMatcher;

    public DestinationPatternsMessageCondition(String[] patterns, PathMatcher pathMatcher) {
        this(DestinationPatternsMessageCondition.asList(patterns), pathMatcher);
    }

    private DestinationPatternsMessageCondition(Collection<String> patterns, PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"pathMatcher is required");
        this.pathMatcher = pathMatcher;
        this.patterns = Collections.unmodifiableSet(new LinkedHashSet<String>(patterns));
    }

    private static List<String> asList(String ... patterns) {
        return patterns != null ? Arrays.asList(patterns) : Collections.emptyList();
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    protected Collection<String> getContent() {
        return this.patterns;
    }

    protected String getToStringInfix() {
        return " || ";
    }

    public DestinationPatternsMessageCondition combine(DestinationPatternsMessageCondition other) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!this.patterns.isEmpty() && !other.patterns.isEmpty()) {
            for (String pattern1 : this.patterns) {
                for (String pattern2 : other.patterns) {
                    result.add(this.pathMatcher.combine(pattern1, pattern2));
                }
            }
        } else if (!this.patterns.isEmpty()) {
            result.addAll(this.patterns);
        } else if (!other.patterns.isEmpty()) {
            result.addAll(other.patterns);
        } else {
            result.add("");
        }
        return new DestinationPatternsMessageCondition(result, this.pathMatcher);
    }

    public DestinationPatternsMessageCondition getMatchingCondition(Message<?> message) {
        WampMessage wampMessage = (WampMessage)message;
        String destination = wampMessage.getDestination();
        if (destination == null) {
            return null;
        }
        if (this.patterns.isEmpty()) {
            return this;
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String pattern : this.patterns) {
            if (!pattern.equals(destination) && !this.pathMatcher.match(pattern, destination) && !"**".equals(destination)) continue;
            matches.add(pattern);
        }
        if (matches.isEmpty()) {
            return null;
        }
        Collections.sort(matches, this.pathMatcher.getPatternComparator(destination));
        return new DestinationPatternsMessageCondition(matches, this.pathMatcher);
    }

    public int compareTo(DestinationPatternsMessageCondition other, Message<?> message) {
        WampMessage wampMessage = (WampMessage)message;
        String destination = wampMessage.getDestination();
        Comparator patternComparator = this.pathMatcher.getPatternComparator(destination);
        Iterator<String> iterator = this.patterns.iterator();
        Iterator<String> iteratorOther = other.patterns.iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = patternComparator.compare(iterator.next(), iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

