/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import ch.rasc.wampspring.config.WampEndpointRegistry;
import ch.rasc.wampspring.config.WampSubProtocolHandler;
import ch.rasc.wampspring.config.WampWebSocketEndpointRegistration;
import ch.rasc.wampspring.config.WebMvcWampWebSocketEndpointRegistration;
import ch.rasc.wampspring.config.WebSocketTransportRegistration;
import com.fasterxml.jackson.core.JsonFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.util.UrlPathHelper;

public class WebMvcWampEndpointRegistry
implements WampEndpointRegistry {
    private final WebSocketHandler webSocketHandler;
    private final SubProtocolWebSocketHandler subProtocolWebSocketHandler;
    private final WampSubProtocolHandler wampSubProtocolHandler;
    private final List<WebMvcWampWebSocketEndpointRegistration> registrations = new ArrayList<WebMvcWampWebSocketEndpointRegistration>();
    private final TaskScheduler sockJsScheduler;
    private List<HandshakeInterceptor> handshakeInterceptors;
    private int order = 1;
    private UrlPathHelper urlPathHelper;

    public WebMvcWampEndpointRegistry(WebSocketHandler webSocketHandler, WebSocketTransportRegistration transportRegistration, TaskScheduler defaultSockJsTaskScheduler, JsonFactory jsonFactory) {
        Assert.notNull((Object)webSocketHandler, (String)"'webSocketHandler' is required ");
        Assert.notNull((Object)transportRegistration, (String)"'transportRegistration' is required");
        Assert.notNull((Object)jsonFactory, (String)"'jsonFactory' is required");
        this.webSocketHandler = webSocketHandler;
        this.subProtocolWebSocketHandler = WebMvcWampEndpointRegistry.unwrapSubProtocolWebSocketHandler(webSocketHandler);
        if (transportRegistration.getSendTimeLimit() != null) {
            this.subProtocolWebSocketHandler.setSendTimeLimit(transportRegistration.getSendTimeLimit().intValue());
        }
        if (transportRegistration.getSendBufferSizeLimit() != null) {
            this.subProtocolWebSocketHandler.setSendBufferSizeLimit(transportRegistration.getSendBufferSizeLimit().intValue());
        }
        this.wampSubProtocolHandler = new WampSubProtocolHandler(jsonFactory);
        this.sockJsScheduler = defaultSockJsTaskScheduler;
    }

    public void addHandshakeInterceptors(List<HandshakeInterceptor> interceptors) {
        this.handshakeInterceptors = interceptors;
    }

    private static SubProtocolWebSocketHandler unwrapSubProtocolWebSocketHandler(WebSocketHandler wsHandler) {
        WebSocketHandler actual = WebSocketHandlerDecorator.unwrap((WebSocketHandler)wsHandler);
        Assert.isInstanceOf(SubProtocolWebSocketHandler.class, (Object)actual, (String)("No SubProtocolWebSocketHandler in " + wsHandler));
        return (SubProtocolWebSocketHandler)actual;
    }

    @Override
    public WampWebSocketEndpointRegistration addEndpoint(String ... paths) {
        this.subProtocolWebSocketHandler.addProtocolHandler((SubProtocolHandler)this.wampSubProtocolHandler);
        WebMvcWampWebSocketEndpointRegistration registration = new WebMvcWampWebSocketEndpointRegistration(paths, this.webSocketHandler, this.sockJsScheduler);
        this.registrations.add(registration);
        if (this.handshakeInterceptors != null && this.handshakeInterceptors.size() > 0) {
            registration.addInterceptors(this.handshakeInterceptors.toArray(new HandshakeInterceptor[this.handshakeInterceptors.size()]));
        }
        return registration;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public AbstractHandlerMapping getHandlerMapping() {
        LinkedHashMap<String, HttpRequestHandler> urlMap = new LinkedHashMap<String, HttpRequestHandler>();
        for (WebMvcWampWebSocketEndpointRegistration registration : this.registrations) {
            MultiValueMap<HttpRequestHandler, String> mappings = registration.getMappings();
            for (HttpRequestHandler httpHandler : mappings.keySet()) {
                for (String pattern : (List)mappings.get((Object)httpHandler)) {
                    urlMap.put(pattern, httpHandler);
                }
            }
        }
        SimpleUrlHandlerMapping hm = new SimpleUrlHandlerMapping();
        hm.setUrlMap(urlMap);
        hm.setOrder(this.order);
        if (this.urlPathHelper != null) {
            hm.setUrlPathHelper(this.urlPathHelper);
        }
        return hm;
    }
}

