/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import ch.rasc.wampspring.config.WampSessionContextHolder;
import ch.rasc.wampspring.message.CallErrorMessage;
import ch.rasc.wampspring.message.CallMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageHeader;
import ch.rasc.wampspring.message.WelcomeMessage;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.SessionLimitExceededException;
import org.springframework.web.socket.messaging.SubProtocolHandler;

public class WampSubProtocolHandler
implements SubProtocolHandler {
    public static final int MINIMUM_WEBSOCKET_MESSAGE_SIZE = 16640;
    private static final Log logger = LogFactory.getLog(WampSubProtocolHandler.class);
    private static final String SERVER_IDENTIFIER = "wampspring/1.1";
    private final JsonFactory jsonFactory;

    public WampSubProtocolHandler(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public List<String> getSupportedProtocols() {
        return Collections.singletonList("wamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessageFromClient(WebSocketSession session, WebSocketMessage<?> webSocketMessage, MessageChannel outputChannel) {
        Assert.isInstanceOf(TextMessage.class, webSocketMessage);
        WampMessage wampMessage = null;
        try {
            wampMessage = (WampMessage)WampMessage.fromJson(session, this.jsonFactory, (String)((TextMessage)webSocketMessage).getPayload());
        }
        catch (Throwable ex) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Failed to parse " + webSocketMessage + " in session " + session.getId() + "."), ex);
            }
            return;
        }
        try {
            WampSessionContextHolder.setAttributesFromMessage(wampMessage);
            outputChannel.send(wampMessage);
        }
        catch (Throwable ex) {
            logger.error((Object)("Failed to send client message to application via MessageChannel in session " + session.getId() + "."), ex);
            if (wampMessage != null && wampMessage instanceof CallMessage) {
                CallErrorMessage callErrorMessage = new CallErrorMessage((CallMessage)wampMessage, "", ex.toString());
                try {
                    String json = callErrorMessage.toJson(this.jsonFactory);
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
                }
                catch (Throwable t) {
                    logger.debug((Object)"Failed to send error to client.", t);
                }
            }
        }
        finally {
            WampSessionContextHolder.resetAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessageToClient(WebSocketSession session, Message<?> message) {
        if (!(message instanceof WampMessage)) {
            logger.error((Object)("Expected WampMessage. Ignoring " + message + "."));
            return;
        }
        boolean closeWebSocketSession = false;
        try {
            String json = ((WampMessage)message).toJson(this.jsonFactory);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
        }
        catch (SessionLimitExceededException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            logger.debug((Object)("Failed to send WebSocket message to client in session " + session.getId() + "."), ex);
            closeWebSocketSession = true;
        }
        finally {
            if (closeWebSocketSession) {
                try {
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                catch (IOException ex) {}
            }
        }
    }

    public String resolveSessionId(Message<?> message) {
        return (String)message.getHeaders().get((Object)WampMessageHeader.WEBSOCKET_SESSION_ID.name());
    }

    public void afterSessionStarted(WebSocketSession session, MessageChannel outputChannel) {
        if (session.getTextMessageSizeLimit() < 16640) {
            session.setTextMessageSizeLimit(16640);
        }
        WelcomeMessage welcomeMessage = new WelcomeMessage(session.getId(), SERVER_IDENTIFIER);
        try {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)welcomeMessage.toJson(this.jsonFactory)));
        }
        catch (IOException e) {
            logger.error((Object)("Failed to send welcome message to client in session " + session.getId() + "."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSessionEnded(WebSocketSession session, CloseStatus closeStatus, MessageChannel outputChannel) {
        UnsubscribeMessage message = UnsubscribeMessage.createCleanupMessage(session);
        try {
            WampSessionContextHolder.setAttributesFromMessage(message);
            outputChannel.send((Message)message);
        }
        finally {
            WampSessionContextHolder.resetAttributes();
            message.getWampSession().sessionCompleted();
        }
    }

    public String toString() {
        return "WampSubProtocolHandler " + this.getSupportedProtocols();
    }
}

