/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import ch.rasc.wampspring.config.WampSession;
import ch.rasc.wampspring.config.WampSessionContextHolder;
import java.io.Serializable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.web.socket.WebSocketSession;

public class WampSessionScope
implements Scope {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        WampSession wampSession = WampSessionContextHolder.currentAttributes();
        Object value = wampSession.getAttribute(name);
        if (value != null) {
            return value;
        }
        Object object = wampSession.getSessionMutex();
        synchronized (object) {
            value = wampSession.getAttribute(name);
            if (value == null) {
                value = objectFactory.getObject();
                wampSession.setAttribute(name, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        WampSession wampSession = WampSessionContextHolder.currentAttributes();
        Object object = wampSession.getSessionMutex();
        synchronized (object) {
            Object value = wampSession.getAttribute(name);
            if (value != null) {
                wampSession.removeAttribute(name);
                return value;
            }
            return null;
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        WampSessionContextHolder.currentAttributes().registerDestructionCallback(name, callback);
    }

    public Object resolveContextualObject(String key) {
        System.out.println("Resolve Contextual Object: " + key);
        if ("wampsession".equals(key)) {
            WampSessionContextHolder.currentAttributes().getWebSocketSession();
        }
        return null;
    }

    public String getConversationId() {
        return WampSessionContextHolder.currentAttributes().getWebSocketSessionId();
    }

    public static class WebSocketSessionObjectFactory
    implements ObjectFactory<WebSocketSession>,
    Serializable {
        public WebSocketSession getObject() {
            return WampSessionContextHolder.currentAttributes().getWebSocketSession();
        }

        public String toString() {
            return "Current WebSocketSession";
        }
    }

    public static class WampSessionObjectFactory
    implements ObjectFactory<WampSession>,
    Serializable {
        public WampSession getObject() {
            return WampSessionContextHolder.currentAttributes();
        }

        public String toString() {
            return "Current WampSession";
        }
    }
}

