/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketSession;

public class WampSession {
    private static final String PREFIXES = WampSession.class.getName() + ".PREFIXES";
    private static final String AUTH_KEY = WampSession.class.getName() + ".AUTH_KEY";
    private static final String CHALLENGE = WampSession.class.getName() + ".CHALLENGE";
    private static final String SIGNATURE = WampSession.class.getName() + ".SIGNATURE";
    public static final String SESSION_MUTEX_NAME = WampSession.class.getName() + ".MUTEX";
    public static final String SESSION_COMPLETED_NAME = WampSession.class.getName() + ".COMPLETED";
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = WampSession.class.getName() + ".DESTRUCTION_CALLBACK.";
    private final WebSocketSession webSocketSession;

    public WampSession(WebSocketSession webSocketSession) {
        this.webSocketSession = webSocketSession;
    }

    public <T> T getAttribute(String name) {
        return (T)this.webSocketSession.getAttributes().get(name);
    }

    public WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    public void setAttribute(String name, Object value) {
        this.webSocketSession.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.webSocketSession.getAttributes().remove(name);
        this.removeDestructionCallback(name);
    }

    public String[] getAttributeNames() {
        return StringUtils.toStringArray(this.webSocketSession.getAttributes().keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Object object = this.getSessionMutex();
        synchronized (object) {
            if (this.isSessionCompleted()) {
                throw new IllegalStateException("Session id=" + this.getWebSocketSessionId() + " already completed");
            }
            this.setAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDestructionCallback(String name) {
        Object object = this.getSessionMutex();
        synchronized (object) {
            this.webSocketSession.getAttributes().remove(DESTRUCTION_CALLBACK_NAME_PREFIX + name);
        }
    }

    public String getWebSocketSessionId() {
        return this.webSocketSession.getId();
    }

    public Object getSessionMutex() {
        Object mutex = this.getAttribute(SESSION_MUTEX_NAME);
        if (mutex == null) {
            mutex = this.webSocketSession.getAttributes();
        }
        return mutex;
    }

    public boolean isSessionCompleted() {
        return this.getAttribute(SESSION_COMPLETED_NAME) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCompleted() {
        Object object = this.getSessionMutex();
        synchronized (object) {
            if (!this.isSessionCompleted()) {
                this.executeDestructionCallbacks();
                this.setAttribute(SESSION_COMPLETED_NAME, Boolean.TRUE);
            }
        }
    }

    private void executeDestructionCallbacks() {
        for (Map.Entry entry : this.webSocketSession.getAttributes().entrySet()) {
            if (!((String)entry.getKey()).startsWith(DESTRUCTION_CALLBACK_NAME_PREFIX)) continue;
            try {
                ((Runnable)entry.getValue()).run();
            }
            catch (Throwable ex) {
                LogFactory.getLog(this.getClass()).error((Object)"Uncaught error in session attribute destruction callback", ex);
            }
        }
    }

    public boolean isAuthRequested() {
        return this.getAuthKey() != null;
    }

    public boolean isAuthenticated() {
        return this.getSignature() != null;
    }

    public String getAuthKey() {
        return (String)this.getAttribute(AUTH_KEY);
    }

    public void setAuthKey(String authKey) {
        this.setAttribute(AUTH_KEY, authKey);
    }

    public String getChallenge() {
        return (String)this.getAttribute(CHALLENGE);
    }

    public void setChallenge(String challenge) {
        this.setAttribute(CHALLENGE, challenge);
    }

    public String getSignature() {
        return (String)this.getAttribute(SIGNATURE);
    }

    public void setSignature(String signature) {
        this.setAttribute(SIGNATURE, signature);
    }

    public void addPrefix(String prefix, String uri) {
        Map<String, String> prefixes = this.getPrefixes();
        if (prefixes == null) {
            prefixes = new HashMap<String, String>();
            this.setAttribute(PREFIXES, prefixes);
        }
        prefixes.put(prefix, uri);
    }

    public boolean hasPrefixes() {
        Map<String, String> prefixes = this.getPrefixes();
        return prefixes == null || prefixes.isEmpty();
    }

    public String getPrefix(String curie) {
        Map<String, String> prefixes = this.getPrefixes();
        if (prefixes != null) {
            return prefixes.get(curie);
        }
        return null;
    }

    public Map<String, String> getPrefixes() {
        return (Map)this.getAttribute(PREFIXES);
    }
}

