/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.session;

import ch.rasc.wampspring.message.WampMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.session.ExpiringSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.util.Assert;

public final class SessionRepositoryMessageInterceptor<S extends ExpiringSession>
extends ChannelInterceptorAdapter {
    private final SessionRepository<S> sessionRepository;

    public SessionRepositoryMessageInterceptor(SessionRepository<S> sessionRepository) {
        Assert.notNull(sessionRepository, (String)"sessionRepository cannot be null");
        this.sessionRepository = sessionRepository;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        ExpiringSession session;
        String sessionId;
        if (message == null) {
            return message;
        }
        if (message instanceof WampMessage && (sessionId = (String)((WampMessage)message).getWampSession().getAttribute("SPRING.SESSION.ID")) != null && (session = (ExpiringSession)this.sessionRepository.getSession(sessionId)) != null) {
            this.sessionRepository.save((Session)session);
        }
        return super.preSend(message, channel);
    }
}

