/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.session;

import ch.rasc.wampspring.session.SessionDisconnectEvent;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.web.socket.events.SessionConnectEvent;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;

public final class WebSocketRegistryListener
implements ApplicationListener<ApplicationEvent> {
    private static final Log logger = LogFactory.getLog(WebSocketRegistryListener.class);
    static final CloseStatus SESSION_EXPIRED_STATUS = new CloseStatus(CloseStatus.POLICY_VIOLATION.getCode(), "This connection was established under an authenticated HTTP Session that has expired");
    private final ConcurrentHashMap<String, Map<String, WebSocketSession>> httpSessionIdToWsSessions = new ConcurrentHashMap();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SessionDestroyedEvent) {
            SessionDestroyedEvent e = (SessionDestroyedEvent)event;
            this.closeWsSessions(e.getSessionId());
        } else if (event instanceof SessionConnectEvent) {
            SessionConnectEvent e = (SessionConnectEvent)event;
            this.afterWsConnectionEstablished(e.getWebSocketSession());
        } else if (event instanceof SessionDisconnectEvent) {
            SessionDisconnectEvent e = (SessionDisconnectEvent)event;
            this.afterWsConnectionClosed(e.getWebSocketSession());
        }
    }

    private void afterWsConnectionEstablished(WebSocketSession wsSession) {
        this.registerWsSession(wsSession);
    }

    private void afterWsConnectionClosed(WebSocketSession wsSession) {
        String httpSessionId = (String)wsSession.getAttributes().get("SPRING.SESSION.ID");
        if (httpSessionId == null) {
            return;
        }
        Map<String, WebSocketSession> sessions = this.httpSessionIdToWsSessions.get(httpSessionId);
        if (sessions != null) {
            boolean result;
            String wsSessionId = wsSession.getId();
            boolean bl = result = sessions.remove(wsSessionId) != null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removal of " + wsSessionId + " was " + result));
            }
            if (sessions.isEmpty()) {
                this.httpSessionIdToWsSessions.remove(httpSessionId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed the corresponding HTTP Session for " + wsSessionId + " since it contained no WebSocket mappings"));
                }
            }
        }
    }

    private void registerWsSession(WebSocketSession wsSession) {
        String httpSessionId = (String)wsSession.getAttributes().get("SPRING.SESSION.ID");
        if (httpSessionId == null) {
            return;
        }
        Map<String, WebSocketSession> sessions = this.httpSessionIdToWsSessions.get(httpSessionId);
        if (sessions == null) {
            sessions = new ConcurrentHashMap<String, WebSocketSession>();
            this.httpSessionIdToWsSessions.putIfAbsent(httpSessionId, sessions);
            sessions = this.httpSessionIdToWsSessions.get(httpSessionId);
        }
        sessions.put(wsSession.getId(), wsSession);
    }

    private void closeWsSessions(String httpSessionId) {
        Map<String, WebSocketSession> sessionsToClose = this.httpSessionIdToWsSessions.remove(httpSessionId);
        if (sessionsToClose == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing WebSocket connections associated to expired HTTP Session " + httpSessionId));
        }
        for (WebSocketSession toClose : sessionsToClose.values()) {
            try {
                toClose.close(SESSION_EXPIRED_STATUS);
            }
            catch (IOException e) {
                logger.debug((Object)"Failed to close WebSocketSession (this is nothing to worry about but for debugging only)", (Throwable)e);
            }
        }
    }
}

