/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.session;

import ch.rasc.wampspring.config.AbstractWampConfigurer;
import ch.rasc.wampspring.config.WebSocketTransportRegistration;
import ch.rasc.wampspring.session.SessionRepositoryHandshakeInterceptor;
import ch.rasc.wampspring.session.SessionRepositoryMessageInterceptor;
import ch.rasc.wampspring.session.WebSocketConnectHandlerDecoratorFactory;
import ch.rasc.wampspring.session.WebSocketRegistryListener;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.session.ExpiringSession;
import org.springframework.session.SessionRepository;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.server.HandshakeInterceptor;

public abstract class AbstractSessionWampConfigurer<S extends ExpiringSession>
extends AbstractWampConfigurer {
    @Autowired
    private SessionRepository<S> sessionRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.addDecoratorFactory((WebSocketHandlerDecoratorFactory)new WebSocketConnectHandlerDecoratorFactory(this.eventPublisher));
    }

    @Bean
    public WebSocketRegistryListener webSocketRegistryListener() {
        return new WebSocketRegistryListener();
    }

    public void addHandshakeInterceptors(List<HandshakeInterceptor> handshakeInterceptors) {
        handshakeInterceptors.add(new SessionRepositoryHandshakeInterceptor());
    }

    public void configureClientInboundChannel(AbstractMessageChannel channel) {
        channel.addInterceptor(new SessionRepositoryMessageInterceptor<S>(this.sessionRepository));
    }
}

