/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.security;

import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageType;
import ch.rasc.wampspring.security.WampMessageTypeMatcher;
import org.springframework.messaging.Message;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

public final class WampDestinationMessageMatcher
implements MessageMatcher<Object> {
    public static final MessageMatcher<Object> NULL_DESTINATION_MATCHER = new MessageMatcher<Object>(){

        public boolean matches(Message<? extends Object> message) {
            if (message instanceof WampMessage) {
                String destination = ((WampMessage)message).getDestination();
                return destination == null;
            }
            return false;
        }
    };
    private final PathMatcher matcher;
    private final MessageMatcher<Object> messageTypeMatcher;
    private final String pattern;

    public WampDestinationMessageMatcher(String pattern) {
        this(pattern, (PathMatcher)new AntPathMatcher());
    }

    public WampDestinationMessageMatcher(String pattern, PathMatcher pathMatcher) {
        this(pattern, null, pathMatcher);
    }

    public WampDestinationMessageMatcher(String pattern, WampMessageType type, PathMatcher pathMatcher) {
        Assert.notNull((Object)pattern, (String)"pattern cannot be null");
        Assert.notNull((Object)pathMatcher, (String)"pathMatcher cannot be null");
        if (!WampDestinationMessageMatcher.isTypeWithDestination(type)) {
            throw new IllegalArgumentException("WampMessageType " + type + " does not contain a destination and so cannot be matched on.");
        }
        this.matcher = pathMatcher;
        this.messageTypeMatcher = type == null ? ANY_MESSAGE : new WampMessageTypeMatcher(type);
        this.pattern = pattern;
    }

    public boolean matches(Message<? extends Object> message) {
        if (!this.messageTypeMatcher.matches(message)) {
            return false;
        }
        if (message instanceof WampMessage) {
            String destination = ((WampMessage)message).getDestination();
            return destination != null && this.matcher.match(this.pattern, destination);
        }
        return false;
    }

    public String toString() {
        return "WampDestinationMessageMatcher [matcher=" + this.matcher + ", messageTypeMatcher=" + this.messageTypeMatcher + ", pattern=" + this.pattern + "]";
    }

    public static boolean isTypeWithDestination(WampMessageType type) {
        if (type == null) {
            return true;
        }
        return type == WampMessageType.CALL || type == WampMessageType.PUBLISH || type == WampMessageType.SUBSCRIBE || type == WampMessageType.UNSUBSCRIBE;
    }
}

