/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.security;

import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageType;
import org.springframework.messaging.Message;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class WampMessageTypeMatcher
implements MessageMatcher<Object> {
    private final WampMessageType typeToMatch;

    public WampMessageTypeMatcher(WampMessageType typeToMatch) {
        Assert.notNull((Object)typeToMatch, (String)"typeToMatch cannot be null");
        this.typeToMatch = typeToMatch;
    }

    public boolean matches(Message<? extends Object> message) {
        if (message instanceof WampMessage) {
            return ((WampMessage)message).getType() == this.typeToMatch;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WampMessageTypeMatcher)) {
            return false;
        }
        WampMessageTypeMatcher otherMatcher = (WampMessageTypeMatcher)other;
        return ObjectUtils.nullSafeEquals((Object)this.typeToMatch, (Object)otherMatcher.typeToMatch);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.typeToMatch);
    }

    public String toString() {
        return "WampMessageTypeMatcher [typeToMatch=" + this.typeToMatch + "]";
    }
}

