/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.util;

import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class InvocableHandlerMethod
extends HandlerMethod {
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    private ParameterNameDiscoverer parameterNameDiscoverer;
    private ConversionService conversionService;
    private ObjectMapper objectMapper;

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public void setArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Nullable
    public Object invoke(WampMessage message, List<Object> arguments, Map<String, Object> argumentsKw) throws Exception {
        Object[] args = this.getMethodArgumentValues(message, arguments, argumentsKw);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking '" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), (Class)this.getBeanType()) + "' with arguments " + Arrays.toString(args)));
        }
        Object returnValue = this.doInvoke(args);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Method [" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), (Class)this.getBeanType()) + "] returned [" + returnValue + "]"));
        }
        return returnValue;
    }

    private Object[] getMethodArgumentValues(WampMessage message, List<Object> arguments, Map<String, Object> argumentsKw) throws Exception {
        MethodParameter[] parameters = this.getMethodParameters();
        Object[] args = new Object[parameters.length];
        int argIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Object arg;
            String paramName;
            MethodParameter parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            if (this.argumentResolvers.supportsParameter(parameter)) {
                try {
                    args[i] = this.argumentResolvers.resolveArgument(parameter, (Message)message);
                    continue;
                }
                catch (Exception ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)this.getArgumentResolutionErrorMessage("Failed to resolve", i), (Throwable)ex);
                    }
                    throw ex;
                }
            }
            if (arguments != null && arguments.size() > argIndex) {
                args[i] = this.convert(parameter, arguments.get(argIndex));
                if (args[i] != null) {
                    ++argIndex;
                    continue;
                }
            }
            if (argumentsKw != null && (paramName = parameter.getParameterName()) != null && (arg = argumentsKw.get(paramName)) != null) {
                args[i] = this.convert(parameter, arg);
                continue;
            }
            if (args[i] != null) continue;
            throw new MethodArgumentResolutionException((Message)message, parameter, this.getArgumentResolutionErrorMessage("No suitable resolver for", i));
        }
        return args;
    }

    @Nullable
    public Object convert(MethodParameter parameter, Object argument) {
        if (argument == null) {
            if (parameter.getParameterType().equals(Optional.class)) {
                return Optional.empty();
            }
            return null;
        }
        Class<?> sourceClass = argument.getClass();
        Class targetClass = parameter.getParameterType();
        TypeDescriptor td = new TypeDescriptor(parameter);
        if (targetClass.isAssignableFrom(sourceClass)) {
            return this.convertListElements(td, argument);
        }
        if (this.conversionService.canConvert(sourceClass, targetClass)) {
            try {
                return this.convertListElements(td, this.conversionService.convert(argument, targetClass));
            }
            catch (Exception e) {
                TypeFactory typeFactory = this.objectMapper.getTypeFactory();
                if (td.getElementTypeDescriptor() != null) {
                    if (td.isCollection()) {
                        JavaType elemType = typeFactory.constructType((Type)td.getElementTypeDescriptor().getType());
                        TypeVariable<Class<T>>[] vars = targetClass.getTypeParameters();
                        TypeBindings bindings = vars == null || vars.length != 1 ? TypeBindings.emptyBindings() : TypeBindings.create((Class)targetClass, (JavaType)elemType);
                        JavaType superClass = null;
                        Class parent = targetClass.getSuperclass();
                        if (parent != null) {
                            superClass = TypeFactory.unknownType();
                        }
                        CollectionType type = CollectionType.construct((Class)targetClass, (TypeBindings)bindings, (JavaType)superClass, null, (JavaType)elemType);
                        return this.objectMapper.convertValue(argument, (JavaType)type);
                    }
                    if (td.isArray()) {
                        ArrayType type = typeFactory.constructArrayType(td.getElementTypeDescriptor().getType());
                        return this.objectMapper.convertValue(argument, (JavaType)type);
                    }
                }
                throw e;
            }
        }
        return this.objectMapper.convertValue(argument, targetClass);
    }

    @Nullable
    private Object convertListElements(TypeDescriptor td, @Nullable Object convertedValue) {
        if (convertedValue != null && List.class.isAssignableFrom(convertedValue.getClass()) && td.isCollection() && td.getElementTypeDescriptor() != null) {
            Class elementType = td.getElementTypeDescriptor().getType();
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : (List)convertedValue) {
                Object convertedObject = this.objectMapper.convertValue(record, elementType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return convertedValue;
    }

    private String getArgumentResolutionErrorMessage(String text, int index) {
        Class paramType = this.getMethodParameters()[index].getParameterType();
        return text + " argument " + index + " of type '" + paramType.getName() + "'";
    }

    @Nullable
    private Object doInvoke(Object ... args) throws Exception {
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        try {
            return this.getBridgedMethod().invoke(this.getBean(), args);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(this.getBridgedMethod(), this.getBean(), args);
            String text = ex.getMessage() != null ? ex.getMessage() : "Illegal argument";
            throw new IllegalStateException(this.getInvocationErrorMessage(text, args), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            String text = this.getInvocationErrorMessage("Failed to invoke handler method", args);
            throw new IllegalStateException(text, targetException);
        }
    }

    private void assertTargetBean(Method method, Object targetBean, Object[] args) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String text = "The mapped handler method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual endpoint bean class '" + targetBeanClass.getName() + "'. If the endpoint requires proxying (e.g. due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.getInvocationErrorMessage(text, args));
        }
    }

    private String getInvocationErrorMessage(String text, Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(this.getDetailedErrorMessage(text));
        sb.append("Resolved arguments: \n");
        for (int i = 0; i < resolvedArgs.length; ++i) {
            sb.append("[").append(i).append("] ");
            if (resolvedArgs[i] == null) {
                sb.append("[null] \n");
                continue;
            }
            sb.append("[type=").append(resolvedArgs[i].getClass().getName()).append("] ");
            sb.append("[value=").append(resolvedArgs[i]).append("]\n");
        }
        return sb.toString();
    }

    private String getDetailedErrorMessage(String text) {
        StringBuilder sb = new StringBuilder(text).append("\n");
        sb.append("HandlerMethod details: \n");
        sb.append("Endpoint [").append(this.getBeanType().getName()).append("]\n");
        sb.append("Method [").append(this.getBridgedMethod().toGenericString()).append("]\n");
        return sb.toString();
    }
}

