/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.rpc;

import ch.rasc.wamp2spring.util.CollectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class WampResult {
    @Nullable
    private List<Object> results;
    @Nullable
    private Map<String, Object> resultsKw;

    public static WampResult createKw(String k, Object v) {
        HashMap<String, Object> kw = new HashMap<String, Object>();
        kw.put(k, v);
        return new WampResult(kw);
    }

    @SafeVarargs
    public static <T> WampResult create(T ... a) {
        ArrayList<T> arg = new ArrayList<T>();
        arg.addAll(Arrays.asList(a));
        return new WampResult(arg);
    }

    public WampResult() {
        this(null, null);
    }

    public <T> WampResult(@Nullable Collection<T> results) {
        this(CollectionHelper.toList(results), null);
    }

    public WampResult(@Nullable Map<String, Object> resultsKw) {
        this(null, resultsKw);
    }

    public WampResult(@Nullable Collection<Object> results, @Nullable Map<String, Object> resultsKw) {
        this.results = CollectionHelper.toList(results);
        this.resultsKw = resultsKw;
    }

    public WampResult add(Object value) {
        if (this.results == null) {
            this.results = new ArrayList<Object>();
        }
        this.results.add(value);
        return this;
    }

    public WampResult add(String key, Object value) {
        if (this.resultsKw == null) {
            this.resultsKw = new HashMap<String, Object>();
        }
        this.resultsKw.put(key, value);
        return this;
    }

    @Nullable
    public List<Object> getResults() {
        return this.results;
    }

    public <T> void setResults(@Nullable Collection<T> results) {
        this.results = CollectionHelper.toList(results);
    }

    @Nullable
    public Map<String, Object> getResultsKw() {
        return this.resultsKw;
    }

    public void setResultsKw(@Nullable Map<String, Object> resultsKw) {
        this.resultsKw = resultsKw;
    }

    public String toString() {
        return "WampResult [results=" + this.results + ", resultsKw=" + this.resultsKw + "]";
    }
}

