/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.rpc;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.annotation.WampProcedure;
import ch.rasc.wamp2spring.config.Feature;
import ch.rasc.wamp2spring.config.Features;
import ch.rasc.wamp2spring.event.WampDisconnectEvent;
import ch.rasc.wamp2spring.event.WampProcedureRegisteredEvent;
import ch.rasc.wamp2spring.event.WampProcedureUnregisteredEvent;
import ch.rasc.wamp2spring.message.CallMessage;
import ch.rasc.wamp2spring.message.ErrorMessage;
import ch.rasc.wamp2spring.message.InvocationMessage;
import ch.rasc.wamp2spring.message.RegisterMessage;
import ch.rasc.wamp2spring.message.RegisteredMessage;
import ch.rasc.wamp2spring.message.ResultMessage;
import ch.rasc.wamp2spring.message.UnregisterMessage;
import ch.rasc.wamp2spring.message.UnregisteredMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import ch.rasc.wamp2spring.message.YieldMessage;
import ch.rasc.wamp2spring.rpc.ProcedureRegistry;
import ch.rasc.wamp2spring.rpc.UnregisterResult;
import ch.rasc.wamp2spring.rpc.WampResult;
import ch.rasc.wamp2spring.util.HandlerMethodService;
import ch.rasc.wamp2spring.util.InvocableHandlerMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RpcMessageHandler
implements MessageHandler,
SmartLifecycle,
InitializingBean,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private boolean autoStartup = true;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();
    private ApplicationContext applicationContext;
    private final ProcedureRegistry procedureRegistry;
    private final Map<String, InvocableHandlerMethod> wampMethods = new ConcurrentHashMap<String, InvocableHandlerMethod>();
    private final HandlerMethodService handlerMethodService;
    private final Features features;

    public RpcMessageHandler(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel, ProcedureRegistry procedureRegistry, HandlerMethodService handlerMethodService, Features features) {
        this.clientInboundChannel = clientInboundChannel;
        this.clientOutboundChannel = clientOutboundChannel;
        this.procedureRegistry = procedureRegistry;
        this.handlerMethodService = handlerMethodService;
        this.features = features;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe((MessageHandler)this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.unsubscribe((MessageHandler)this);
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(Message<?> message) {
        if (!this.running) {
            if (!this.logger.isTraceEnabled()) return;
            this.logger.trace((Object)(this + " not running yet. Ignoring " + message));
            return;
        }
        if (message instanceof RegisterMessage) {
            RegisterMessage registerMessage = (RegisterMessage)message;
            long registrationId = this.procedureRegistry.register(registerMessage);
            if (registrationId != -1L) {
                this.sendMessageToClient(new RegisteredMessage(registerMessage, registrationId));
                this.applicationContext.publishEvent((Object)new WampProcedureRegisteredEvent(registerMessage, registrationId));
                return;
            } else {
                this.sendMessageToClient(new ErrorMessage(registerMessage, WampError.PROCEDURE_ALREADY_EXISTS));
            }
            return;
        } else if (message instanceof UnregisterMessage) {
            UnregisterMessage unregisterMessage = (UnregisterMessage)message;
            UnregisterResult result = this.procedureRegistry.unregister(unregisterMessage);
            if (result.isSuccess()) {
                this.sendMessageToClient(new UnregisteredMessage(unregisterMessage));
                this.applicationContext.publishEvent((Object)new WampProcedureUnregisteredEvent(unregisterMessage, result.getProcedure(), result.getRegistrationId()));
                for (ErrorMessage errorMessage : result.getInvocationErrors()) {
                    this.handleErrorMessage(errorMessage);
                }
                return;
            } else {
                this.sendMessageToClient(new ErrorMessage(unregisterMessage, WampError.NO_SUCH_REGISTRATION));
            }
            return;
        } else if (message instanceof CallMessage) {
            InvocableHandlerMethod handlerMethod;
            CallMessage callMessage = (CallMessage)message;
            if (callMessage.isDiscloseMe() && this.features.isDisabled(Feature.DEALER_CALLER_IDENTIFICATION)) {
                this.sendMessageToClient(new ErrorMessage(callMessage, WampError.DISCLOSE_ME_DISALLOWED));
            }
            if ((handlerMethod = this.wampMethods.get(callMessage.getProcedure())) != null) {
                this.callWampMethod(callMessage, handlerMethod);
                return;
            } else {
                WampMessage errorOrInvocationMessage = this.procedureRegistry.createInvocationMessage(callMessage);
                try {
                    this.clientOutboundChannel.send((Message)errorOrInvocationMessage);
                    return;
                }
                catch (Throwable ex) {
                    if (!(errorOrInvocationMessage instanceof InvocationMessage)) return;
                    this.sendMessageToClient(new ErrorMessage(callMessage, WampError.NETWORK_FAILURE));
                }
            }
            return;
        } else if (message instanceof YieldMessage) {
            YieldMessage yieldMessage = (YieldMessage)message;
            CallMessage callMessage = this.procedureRegistry.removeInvocationCall(yieldMessage);
            if (callMessage == null) return;
            ResultMessage resultMessage = new ResultMessage(yieldMessage, callMessage);
            this.sendMessageToClient(resultMessage);
            return;
        } else {
            if (!(message instanceof ErrorMessage)) return;
            this.handleErrorMessage((ErrorMessage)message);
        }
    }

    @EventListener
    void handleDisconnectEvent(WampDisconnectEvent event) {
        List<UnregisterResult> unregisterResults = this.procedureRegistry.unregisterWebSocketSession(event.getWebSocketSessionId());
        for (UnregisterResult unregisterResult : unregisterResults) {
            this.applicationContext.publishEvent((Object)new WampProcedureUnregisteredEvent(event, unregisterResult.getProcedure(), unregisterResult.getRegistrationId()));
            for (ErrorMessage errorMessage : unregisterResult.getInvocationErrors()) {
                this.handleErrorMessage(errorMessage);
            }
        }
    }

    private void handleErrorMessage(ErrorMessage errorMessage) {
        CallMessage callMessage = this.procedureRegistry.removeInvocationCall(errorMessage);
        if (callMessage != null) {
            ErrorMessage calErrorMessage = new ErrorMessage(errorMessage, callMessage);
            this.sendMessageToClient(calErrorMessage);
        }
    }

    private void callWampMethod(CallMessage callMessage, InvocableHandlerMethod handlerMethod) {
        block6: {
            try {
                ResultMessage resultMessage;
                Object returnValue = this.handlerMethodService.invoke(callMessage, handlerMethod);
                if (returnValue instanceof WampResult) {
                    WampResult wampResult = (WampResult)returnValue;
                    resultMessage = new ResultMessage(callMessage, wampResult.getResults(), wampResult.getResultsKw());
                } else {
                    resultMessage = new ResultMessage(callMessage, returnValue != null ? Collections.singletonList(returnValue) : null, null);
                }
                this.sendMessageToClient(resultMessage);
            }
            catch (Exception e) {
                if ("org.springframework.security.access.AccessDeniedException".equals(e.getClass().getName())) {
                    this.sendMessageToClient(new ErrorMessage(callMessage, WampError.NOT_AUTHORIZED));
                } else {
                    this.sendMessageToClient(new ErrorMessage(callMessage, WampError.INVALID_ARGUMENT));
                }
                if (!this.logger.isErrorEnabled()) break block6;
                this.logger.error((Object)("Error while invoking the handlerMethod " + (Object)((Object)handlerMethod)), (Throwable)e);
            }
        }
    }

    protected void sendMessageToClient(Message<?> message) {
        try {
            this.clientOutboundChannel.send(message);
        }
        catch (Throwable ex) {
            this.logger.error((Object)("Failed to send " + message), ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (String beanName : this.applicationContext.getBeanNamesForType(Object.class)) {
            Class handlerType = this.applicationContext.getType(beanName);
            if (handlerType == null) continue;
            Class userType = ClassUtils.getUserClass((Class)handlerType);
            this.detectWampMethods(beanName, userType);
        }
    }

    private void detectWampMethods(String beanName, Class<?> userType) {
        Set methods = MethodIntrospector.selectMethods(userType, method -> AnnotationUtils.findAnnotation((Method)method, WampProcedure.class) != null);
        for (Method method2 : methods) {
            WampProcedure annotation = (WampProcedure)AnnotationUtils.findAnnotation((Method)method2, WampProcedure.class);
            InvocableHandlerMethod handlerMethod = new InvocableHandlerMethod(new HandlerMethod(this.applicationContext.getBean(beanName), method2));
            String procedure = (String)AnnotationUtils.getValue((Annotation)annotation);
            if (!StringUtils.hasText((String)procedure)) {
                procedure = beanName + "." + method2.getName();
            }
            this.wampMethods.put(procedure, handlerMethod);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Mapped \"" + procedure + "\" onto " + (Object)((Object)handlerMethod)));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

