/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class YieldMessage
extends WampMessage {
    static final int CODE = 70;
    private final long requestId;
    @Nullable
    private final List<Object> arguments;
    @Nullable
    private final Map<String, Object> argumentsKw;

    public YieldMessage(long requestId, @Nullable List<Object> arguments, @Nullable Map<String, Object> argumentsKw) {
        super(70);
        this.requestId = requestId;
        this.arguments = arguments;
        this.argumentsKw = argumentsKw;
    }

    public static YieldMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        jp.nextToken();
        ParserUtil.readObject(jp);
        List<Object> arguments = null;
        JsonToken token = jp.nextToken();
        if (token == JsonToken.START_ARRAY) {
            arguments = ParserUtil.readArray(jp);
        }
        Map<String, Object> argumentsKw = null;
        token = jp.nextToken();
        if (token == JsonToken.START_OBJECT) {
            argumentsKw = ParserUtil.readObject(jp);
        }
        return new YieldMessage(request, arguments, argumentsKw);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeStartObject();
        generator.writeEndObject();
        if (this.argumentsKw != null) {
            if (this.arguments == null) {
                generator.writeStartArray();
                generator.writeEndArray();
            } else {
                generator.writeObject(this.arguments);
            }
            generator.writeObject(this.argumentsKw);
        } else if (this.arguments != null) {
            generator.writeObject(this.arguments);
        }
    }

    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Nullable
    public Map<String, Object> getArgumentsKw() {
        return this.argumentsKw;
    }

    public String toString() {
        return "YieldMessage [requestId=" + this.requestId + ", arguments=" + this.arguments + ", argumentsKw=" + this.argumentsKw + "]";
    }
}

