/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.HelloMessage;
import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import ch.rasc.wamp2spring.message.WampMessageHeader;
import ch.rasc.wamp2spring.message.WampRole;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class WelcomeMessage
extends WampMessage {
    static final int CODE = 2;
    private final long sessionId;
    private final List<WampRole> roles;
    @Nullable
    private final String realm;

    public WelcomeMessage(long sessionId, List<WampRole> roles, @Nullable String realm) {
        super(2);
        this.sessionId = sessionId;
        this.roles = roles;
        this.realm = realm;
    }

    public WelcomeMessage(HelloMessage helloMessage, long sessionId, List<WampRole> roles) {
        this(sessionId, roles, null);
        this.setReceiver(helloMessage);
        this.setHeader(WampMessageHeader.WAMP_SESSION_ID, sessionId);
    }

    public static WelcomeMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long session = jp.getLongValue();
        ArrayList<WampRole> roles = new ArrayList<WampRole>();
        String realm = null;
        jp.nextToken();
        Map<String, Object> details = ParserUtil.readObject(jp);
        if (details != null) {
            Map rolesMap = (Map)details.get("roles");
            for (Map.Entry entry : rolesMap.entrySet()) {
                WampRole wampRole = new WampRole((String)entry.getKey());
                Map features = (Map)((Map)entry.getValue()).get("features");
                if (features != null) {
                    for (String feature : features.keySet()) {
                        wampRole.addFeature(feature);
                    }
                }
                roles.add(wampRole);
            }
            realm = (String)details.get("realm");
        }
        return new WelcomeMessage(session, roles, realm);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.sessionId);
        generator.writeStartObject();
        generator.writeObjectFieldStart("roles");
        for (WampRole wampRole : this.roles) {
            generator.writeObjectFieldStart(wampRole.getRole());
            if (wampRole.hasFeatures()) {
                generator.writeObjectFieldStart("features");
                for (String feature : wampRole.getFeatures()) {
                    generator.writeBooleanField(feature, true);
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
        generator.writeEndObject();
        if (this.realm != null) {
            generator.writeStringField("realm", this.realm);
        }
        generator.writeEndObject();
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public List<WampRole> getRoles() {
        return this.roles;
    }

    @Nullable
    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        return "WelcomeMessage [sessionId=" + this.sessionId + ", roles=" + this.roles + ", realm=" + this.realm + "]";
    }
}

