/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.AbortMessage;
import ch.rasc.wamp2spring.message.CallMessage;
import ch.rasc.wamp2spring.message.ErrorMessage;
import ch.rasc.wamp2spring.message.EventMessage;
import ch.rasc.wamp2spring.message.GoodbyeMessage;
import ch.rasc.wamp2spring.message.HelloMessage;
import ch.rasc.wamp2spring.message.InvocationMessage;
import ch.rasc.wamp2spring.message.PublishMessage;
import ch.rasc.wamp2spring.message.PublishedMessage;
import ch.rasc.wamp2spring.message.RegisterMessage;
import ch.rasc.wamp2spring.message.RegisteredMessage;
import ch.rasc.wamp2spring.message.ResultMessage;
import ch.rasc.wamp2spring.message.SubscribeMessage;
import ch.rasc.wamp2spring.message.SubscribedMessage;
import ch.rasc.wamp2spring.message.UnregisterMessage;
import ch.rasc.wamp2spring.message.UnregisteredMessage;
import ch.rasc.wamp2spring.message.UnsubscribeMessage;
import ch.rasc.wamp2spring.message.UnsubscribedMessage;
import ch.rasc.wamp2spring.message.WampMessageHeader;
import ch.rasc.wamp2spring.message.WelcomeMessage;
import ch.rasc.wamp2spring.message.YieldMessage;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.web.socket.WebSocketSession;

public abstract class WampMessage
implements Message<Object> {
    private static final Object EMPTY_OBJECT = new Object();
    private final MutableMessageHeaders messageHeaders = new MutableMessageHeaders();
    private final int code;

    WampMessage(int code) {
        this.code = code;
        this.setHeader(WampMessageHeader.WAMP_MESSAGE_CODE, code);
    }

    public int getCode() {
        return this.code;
    }

    public void setHeader(WampMessageHeader header, @Nullable Object value) {
        if (value != null) {
            this.messageHeaders.getRawHeaders().put(header.name(), value);
        }
    }

    @Nullable
    public <T> T getHeader(WampMessageHeader header) {
        return (T)this.messageHeaders.get(header.name());
    }

    @Nullable
    public String getWebSocketSessionId() {
        return (String)this.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
    }

    @Nullable
    public Principal getPrincipal() {
        return (Principal)this.getHeader(WampMessageHeader.PRINCIPAL);
    }

    @Nullable
    public Long getWampSessionId() {
        return (Long)this.getHeader(WampMessageHeader.WAMP_SESSION_ID);
    }

    public void setWebSocketSession(WebSocketSession webSocketSession) {
        this.setHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, webSocketSession.getId());
        this.setHeader(WampMessageHeader.PRINCIPAL, webSocketSession.getPrincipal());
        this.setHeader(WampMessageHeader.WAMP_SESSION_ID, webSocketSession.getAttributes().get(WampMessageHeader.WAMP_SESSION_ID.name()));
    }

    protected void setReceiver(WampMessage message) {
        this.setHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, message.getWebSocketSessionId());
        this.setHeader(WampMessageHeader.PRINCIPAL, message.getPrincipal());
        this.setHeader(WampMessageHeader.WAMP_SESSION_ID, message.getWampSessionId());
    }

    protected void setReceiverWebSocketSessionId(String receiverWebSocketSessionId) {
        this.setHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, receiverWebSocketSessionId);
    }

    public Object getPayload() {
        return EMPTY_OBJECT;
    }

    public MessageHeaders getHeaders() {
        return this.messageHeaders;
    }

    public abstract void serialize(JsonGenerator var1) throws IOException;

    @Nullable
    public static <T extends WampMessage> T deserialize(JsonFactory jsonFactory, byte[] json) throws JsonParseException, IOException {
        try (JsonParser jp = jsonFactory.createParser(json);){
            if (jp.nextToken() != JsonToken.START_ARRAY) {
                throw new IOException("Not a JSON array");
            }
            if (jp.nextToken() != JsonToken.VALUE_NUMBER_INT) {
                throw new IOException("Wrong message format");
            }
            int code = jp.getValueAsInt();
            switch (code) {
                case 1: {
                    HelloMessage helloMessage = HelloMessage.deserialize(jp);
                    return (T)helloMessage;
                }
                case 2: {
                    WelcomeMessage welcomeMessage = WelcomeMessage.deserialize(jp);
                    return (T)welcomeMessage;
                }
                case 3: {
                    AbortMessage abortMessage = AbortMessage.deserialize(jp);
                    return (T)abortMessage;
                }
                case 6: {
                    GoodbyeMessage goodbyeMessage = GoodbyeMessage.deserialize(jp);
                    return (T)goodbyeMessage;
                }
                case 8: {
                    ErrorMessage errorMessage = ErrorMessage.deserialize(jp);
                    return (T)errorMessage;
                }
                case 16: {
                    PublishMessage publishMessage = PublishMessage.deserialize(jp);
                    return (T)publishMessage;
                }
                case 17: {
                    PublishedMessage publishedMessage = PublishedMessage.deserialize(jp);
                    return (T)publishedMessage;
                }
                case 32: {
                    SubscribeMessage subscribeMessage = SubscribeMessage.deserialize(jp);
                    return (T)subscribeMessage;
                }
                case 33: {
                    SubscribedMessage subscribedMessage = SubscribedMessage.deserialize(jp);
                    return (T)subscribedMessage;
                }
                case 34: {
                    UnsubscribeMessage unsubscribeMessage = UnsubscribeMessage.deserialize(jp);
                    return (T)unsubscribeMessage;
                }
                case 35: {
                    UnsubscribedMessage unsubscribedMessage = UnsubscribedMessage.deserialize(jp);
                    return (T)unsubscribedMessage;
                }
                case 36: {
                    EventMessage eventMessage = EventMessage.deserialize(jp);
                    return (T)eventMessage;
                }
                case 48: {
                    CallMessage callMessage = CallMessage.deserialize(jp);
                    return (T)callMessage;
                }
                case 50: {
                    ResultMessage resultMessage = ResultMessage.deserialize(jp);
                    return (T)resultMessage;
                }
                case 64: {
                    RegisterMessage registerMessage = RegisterMessage.deserialize(jp);
                    return (T)registerMessage;
                }
                case 65: {
                    RegisteredMessage registeredMessage = RegisteredMessage.deserialize(jp);
                    return (T)registeredMessage;
                }
                case 66: {
                    UnregisterMessage unregisterMessage = UnregisterMessage.deserialize(jp);
                    return (T)unregisterMessage;
                }
                case 67: {
                    UnregisteredMessage unregisteredMessage = UnregisteredMessage.deserialize(jp);
                    return (T)unregisteredMessage;
                }
                case 70: {
                    YieldMessage yieldMessage = YieldMessage.deserialize(jp);
                    return (T)yieldMessage;
                }
                case 68: {
                    InvocationMessage invocationMessage = InvocationMessage.deserialize(jp);
                    return (T)invocationMessage;
                }
            }
            T t = null;
            return t;
        }
    }

    private static class MutableMessageHeaders
    extends MessageHeaders {
        public MutableMessageHeaders() {
            super(null, MessageHeaders.ID_VALUE_NONE, Long.valueOf(-1L));
        }

        public Map<String, Object> getRawHeaders() {
            return super.getRawHeaders();
        }
    }
}

