/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.PublishMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;

public class PublishedMessage
extends WampMessage {
    static final int CODE = 17;
    private final long requestId;
    private final long publicationId;

    public PublishedMessage(long requestId, long publicationId) {
        super(17);
        this.requestId = requestId;
        this.publicationId = publicationId;
    }

    public PublishedMessage(PublishMessage publishMessage, long publicationId) {
        this(publishMessage.getRequestId(), publicationId);
        this.setReceiver(publishMessage);
    }

    public static PublishedMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        jp.nextToken();
        long subscription = jp.getLongValue();
        return new PublishedMessage(request, subscription);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeNumber(this.publicationId);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getPublicationId() {
        return this.publicationId;
    }

    public String toString() {
        return "PublishedMessage [requestId=" + this.requestId + ", publicationId=" + this.publicationId + "]";
    }
}

