/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import ch.rasc.wamp2spring.message.WampRole;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class HelloMessage
extends WampMessage {
    static final int CODE = 1;
    @Nullable
    private final String realm;
    private final List<WampRole> roles;

    public HelloMessage(@Nullable String realm, List<WampRole> roles) {
        super(1);
        this.realm = realm;
        this.roles = roles;
    }

    public static HelloMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        String realm = jp.getValueAsString();
        ArrayList<WampRole> roles = new ArrayList<WampRole>();
        jp.nextToken();
        Map<String, Object> details = ParserUtil.readObject(jp);
        if (details != null) {
            Map rolesMap = (Map)details.get("roles");
            for (Map.Entry entry : rolesMap.entrySet()) {
                WampRole wampRole = new WampRole((String)entry.getKey());
                Map features = (Map)((Map)entry.getValue()).get("features");
                if (features != null) {
                    for (String feature : features.keySet()) {
                        wampRole.addFeature(feature);
                    }
                }
                roles.add(wampRole);
            }
        }
        return new HelloMessage(realm, roles);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeString(this.realm);
        generator.writeStartObject();
        generator.writeObjectFieldStart("roles");
        for (WampRole wampRole : this.roles) {
            generator.writeObjectFieldStart(wampRole.getRole());
            if (wampRole.hasFeatures()) {
                generator.writeObjectFieldStart("features");
                for (String feature : wampRole.getFeatures()) {
                    generator.writeBooleanField(feature, true);
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
        generator.writeEndObject();
        generator.writeEndObject();
    }

    @Nullable
    public String getRealm() {
        return this.realm;
    }

    public List<WampRole> getRoles() {
        return this.roles;
    }

    public String toString() {
        return "HelloMessage [realm=" + this.realm + ", roles=" + this.roles + "]";
    }
}

