/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class CallMessage
extends WampMessage {
    public static final int CODE = 48;
    private final long requestId;
    private final String procedure;
    private final boolean discloseMe;
    @Nullable
    private final List<Object> arguments;
    @Nullable
    private final Map<String, Object> argumentsKw;

    public CallMessage(long request, String procedure) {
        this(request, procedure, null, null, false);
    }

    public CallMessage(long request, String procedure, @Nullable List<Object> arguments) {
        this(request, procedure, arguments, null, false);
    }

    public CallMessage(long request, String procedure, @Nullable Map<String, Object> argumentsKw) {
        this(request, procedure, null, argumentsKw, false);
    }

    public CallMessage(long requestId, String procedure, @Nullable List<Object> arguments, @Nullable Map<String, Object> argumentsKw, boolean discloseMe) {
        super(48);
        this.requestId = requestId;
        this.procedure = procedure;
        this.arguments = arguments;
        this.argumentsKw = argumentsKw;
        this.discloseMe = discloseMe;
    }

    public static CallMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        boolean discloseMe = false;
        jp.nextToken();
        Map<String, Object> options = ParserUtil.readObject(jp);
        if (options != null) {
            discloseMe = (Boolean)options.getOrDefault("disclose_me", false);
        }
        jp.nextToken();
        String procedure = jp.getValueAsString();
        List<Object> arguments = null;
        JsonToken token = jp.nextToken();
        if (token == JsonToken.START_ARRAY) {
            arguments = ParserUtil.readArray(jp);
        }
        Map<String, Object> argumentsKw = null;
        token = jp.nextToken();
        if (token == JsonToken.START_OBJECT) {
            argumentsKw = ParserUtil.readObject(jp);
        }
        return new CallMessage(request, procedure, arguments, argumentsKw, discloseMe);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeStartObject();
        if (this.discloseMe) {
            generator.writeBooleanField("disclose_me", this.discloseMe);
        }
        generator.writeEndObject();
        generator.writeString(this.procedure);
        if (this.argumentsKw != null) {
            if (this.arguments == null) {
                generator.writeStartArray();
                generator.writeEndArray();
            } else {
                generator.writeObject(this.arguments);
            }
            generator.writeObject(this.argumentsKw);
        } else if (this.arguments != null) {
            generator.writeObject(this.arguments);
        }
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String getProcedure() {
        return this.procedure;
    }

    @Nullable
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Nullable
    public Map<String, Object> getArgumentsKw() {
        return this.argumentsKw;
    }

    public boolean isDiscloseMe() {
        return this.discloseMe;
    }

    public String toString() {
        return "CallMessage [requestId=" + this.requestId + ", procedure=" + this.procedure + ", discloseMe=" + this.discloseMe + ", arguments=" + this.arguments + ", argumentsKw=" + this.argumentsKw + "]";
    }
}

