/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Map;
import org.springframework.lang.Nullable;

public class AbortMessage
extends WampMessage {
    static final int CODE = 3;
    @Nullable
    private final String message;
    @Nullable
    private final String reason;

    public AbortMessage(WampError reason, @Nullable String message) {
        this(reason.getExternalValue(), message);
    }

    public AbortMessage(WampError reason) {
        this(reason.getExternalValue(), null);
    }

    private AbortMessage(String reason, @Nullable String message) {
        super(3);
        this.reason = reason;
        this.message = message;
    }

    public static AbortMessage deserialize(JsonParser jp) throws IOException {
        String msg = null;
        jp.nextToken();
        Map<String, Object> details = ParserUtil.readObject(jp);
        if (details != null) {
            msg = (String)details.get("message");
        }
        jp.nextToken();
        return new AbortMessage(jp.getValueAsString(), msg);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeStartObject();
        if (this.message != null) {
            generator.writeStringField("message", this.message);
        }
        generator.writeEndObject();
        generator.writeString(this.reason);
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "AbortMessage [message=" + this.message + ", reason=" + this.reason + "]";
    }
}

