/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.config;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.config.Feature;
import ch.rasc.wamp2spring.config.Features;
import ch.rasc.wamp2spring.event.WampDisconnectEvent;
import ch.rasc.wamp2spring.event.WampSessionEstablishedEvent;
import ch.rasc.wamp2spring.message.AbortMessage;
import ch.rasc.wamp2spring.message.ErrorMessage;
import ch.rasc.wamp2spring.message.GoodbyeMessage;
import ch.rasc.wamp2spring.message.HelloMessage;
import ch.rasc.wamp2spring.message.InvocationMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import ch.rasc.wamp2spring.message.WampMessageHeader;
import ch.rasc.wamp2spring.message.WampRole;
import ch.rasc.wamp2spring.message.WelcomeMessage;
import ch.rasc.wamp2spring.util.IdGenerator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.SubProtocolHandler;

public class WampSubProtocolHandler
implements SubProtocolHandler,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(WampSubProtocolHandler.class);
    public static final String JSON_PROTOCOL = "wamp.2.json";
    public static final String MSGPACK_PROTOCOL = "wamp.2.msgpack";
    public static final String CBOR_PROTOCOL = "wamp.2.cbor";
    public static final String SMILE_PROTOCOL = "wamp.2.smile";
    private static final List<String> supportedProtocols = Arrays.asList("wamp.2.msgpack", "wamp.2.json", "wamp.2.cbor", "wamp.2.smile");
    private final JsonFactory jsonFactory;
    private final JsonFactory msgpackFactory;
    private final JsonFactory cborFactory;
    private final JsonFactory smileFactory;
    private final List<WampRole> roles;
    private final Set<Long> wampSessionIds = ConcurrentHashMap.newKeySet();
    private final MessageChannel clientInboundChannel;
    private ApplicationEventPublisher applicationEventPublisher;

    public WampSubProtocolHandler(JsonFactory jsonFactory, JsonFactory msgpackFactory, JsonFactory cborFactory, JsonFactory smileFactory, MessageChannel clientInboundChannel, Features features) {
        this.jsonFactory = jsonFactory;
        this.msgpackFactory = msgpackFactory;
        this.cborFactory = cborFactory;
        this.smileFactory = smileFactory;
        this.clientInboundChannel = clientInboundChannel;
        this.roles = new ArrayList<WampRole>();
        if (features.isEnabled(Feature.DEALER)) {
            WampRole dealer = new WampRole(Feature.DEALER.getExternalValue());
            for (Feature feature : features.enabledDealerFeatures()) {
                dealer.addFeature(feature.getExternalValue());
            }
            this.roles.add(dealer);
        }
        if (features.isEnabled(Feature.BROKER)) {
            WampRole broker = new WampRole(Feature.BROKER.getExternalValue());
            for (Feature feature : features.enabledBrokerFeatures()) {
                broker.addFeature(feature.getExternalValue());
            }
            this.roles.add(broker);
        }
    }

    public List<String> getSupportedProtocols() {
        return supportedProtocols;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessageFromClient(WebSocketSession session, WebSocketMessage<?> webSocketMessage, MessageChannel outputChannel) {
        try {
            void var4_10;
            Object var4_4 = null;
            if (webSocketMessage instanceof TextMessage) {
                Object t = WampMessage.deserialize(this.jsonFactory, ((TextMessage)webSocketMessage).asBytes());
            } else {
                if (!(webSocketMessage instanceof BinaryMessage)) return;
                ByteBuffer byteBuffer = (ByteBuffer)((BinaryMessage)webSocketMessage).getPayload();
                String acceptedProtocol = session.getAcceptedProtocol();
                if (acceptedProtocol != null) {
                    if (acceptedProtocol.equals(MSGPACK_PROTOCOL)) {
                        Object t = WampMessage.deserialize(this.msgpackFactory, byteBuffer.array());
                    } else if (acceptedProtocol.equals(SMILE_PROTOCOL)) {
                        Object t = WampMessage.deserialize(this.smileFactory, byteBuffer.array());
                    } else if (acceptedProtocol.equals(CBOR_PROTOCOL)) {
                        Object t = WampMessage.deserialize(this.cborFactory, byteBuffer.array());
                    }
                } else {
                    if (!logger.isErrorEnabled()) return;
                    logger.error((Object)("Deserialization failed because no accepted protocol " + webSocketMessage + " in session " + session.getId()));
                    return;
                }
            }
            if (var4_10 == null) {
                if (!logger.isErrorEnabled()) return;
                logger.error((Object)("Deserialization failed for message " + webSocketMessage + " in session " + session.getId()));
                return;
            }
            var4_10.setWebSocketSession(session);
            if (var4_10 instanceof HelloMessage) {
                if (var4_10.getWampSessionId() != null) {
                    logger.error((Object)"HelloMessage received during running session");
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                long newWampSessionId = IdGenerator.newRandomId(this.wampSessionIds);
                this.wampSessionIds.add(newWampSessionId);
                session.getAttributes().put(WampMessageHeader.WAMP_SESSION_ID.name(), newWampSessionId);
                WelcomeMessage welcomeMessage = new WelcomeMessage((HelloMessage)var4_10, newWampSessionId, this.roles);
                this.handleMessageToClient(session, welcomeMessage);
                this.applicationEventPublisher.publishEvent((Object)new WampSessionEstablishedEvent(welcomeMessage));
                return;
            } else if (var4_10 instanceof AbortMessage) {
                session.close(CloseStatus.GOING_AWAY);
                return;
            } else if (var4_10 instanceof GoodbyeMessage) {
                GoodbyeMessage goodbyeMessage = new GoodbyeMessage(WampError.GOODBYE_AND_OUT);
                this.handleMessageToClient(session, goodbyeMessage);
                session.close(CloseStatus.GOING_AWAY);
                return;
            } else {
                if (var4_10.getWampSessionId() == null) {
                    logger.error((Object)"Session not established");
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                outputChannel.send((Message)var4_10);
            }
            return;
        }
        catch (IOException iOException) {
            if (!logger.isErrorEnabled()) return;
            logger.error((Object)("Failed to parse " + webSocketMessage + " in session " + session.getId()), (Throwable)iOException);
        }
    }

    public void handleMessageToClient(WebSocketSession session, Message<?> message) {
        if (!(message instanceof WampMessage)) {
            logger.error((Object)("Expected WampMessage. Ignoring " + message + "."));
            return;
        }
        WampMessage wampMessage = (WampMessage)message;
        JsonFactory useFactory = this.jsonFactory;
        boolean isBinary = false;
        String acceptedProtocol = session.getAcceptedProtocol();
        if (acceptedProtocol != null) {
            if (acceptedProtocol.equals(MSGPACK_PROTOCOL)) {
                isBinary = true;
                useFactory = this.msgpackFactory;
            } else if (acceptedProtocol.equals(SMILE_PROTOCOL)) {
                isBinary = true;
                useFactory = this.smileFactory;
            } else if (acceptedProtocol.equals(CBOR_PROTOCOL)) {
                isBinary = true;
                useFactory = this.cborFactory;
            }
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 JsonGenerator generator = useFactory.createGenerator((OutputStream)bos);){
                generator.writeStartArray();
                wampMessage.serialize(generator);
                generator.writeEndArray();
                generator.close();
                if (isBinary) {
                    session.sendMessage((WebSocketMessage)new BinaryMessage(bos.toByteArray()));
                } else {
                    session.sendMessage((WebSocketMessage)new TextMessage(bos.toByteArray()));
                }
            }
            catch (Throwable ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to send WebSocket message to client in session " + session.getId()), ex);
                }
                if (message instanceof InvocationMessage) {
                    ErrorMessage errorMessage = new ErrorMessage((InvocationMessage)message, WampError.NETWORK_FAILURE);
                    this.clientInboundChannel.send((Message)errorMessage);
                }
                try {
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                catch (IOException iOException) {}
            }
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)("Failed to send WebSocket message to client because no accepted protocol " + session.getId()));
        }
    }

    public String resolveSessionId(Message<?> message) {
        return (String)message.getHeaders().get((Object)WampMessageHeader.WEBSOCKET_SESSION_ID.name());
    }

    public void afterSessionStarted(WebSocketSession session, MessageChannel outputChannel) {
    }

    public void afterSessionEnded(WebSocketSession session, CloseStatus closeStatus, MessageChannel outputChannel) {
        Long wampSessionId = (Long)session.getAttributes().get(WampMessageHeader.WAMP_SESSION_ID.name());
        if (wampSessionId != null) {
            this.applicationEventPublisher.publishEvent((Object)new WampDisconnectEvent(wampSessionId, session.getId(), session.getPrincipal()));
            this.wampSessionIds.remove(wampSessionId);
            session.getAttributes().remove(WampMessageHeader.WAMP_SESSION_ID.name());
        }
    }

    public String toString() {
        return "WampSubProtocolHandler " + this.getSupportedProtocols();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

