/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring;

import ch.rasc.wamp2spring.message.PublishMessage;
import ch.rasc.wamp2spring.util.CollectionHelper;
import ch.rasc.wamp2spring.util.IdGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class WampPublisher {
    private final MessageChannel clientInboundChannel;
    private final AtomicLong atomicLong = new AtomicLong();

    public WampPublisher(MessageChannel clientInboundChannel) {
        this.clientInboundChannel = clientInboundChannel;
    }

    public void publish(PublishMessage publishMessage) {
        this.clientInboundChannel.send((Message)publishMessage);
    }

    public <T> void publishToAll(String topic, T ... arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).build());
    }

    public <T> void publishToAll(String topic, @Nullable Collection<T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).build());
    }

    public <T> void publishToAll(String topic, @Nullable Map<String, T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(arguments).build());
    }

    public <T> void publishTo(Collection<Long> eligibleWampSessionIds, String topic, T ... arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).eligible(CollectionHelper.toSet(eligibleWampSessionIds)).build());
    }

    public <T> void publishTo(Collection<Long> eligibleWampSessionIds, String topic, @Nullable Collection<T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).eligible(CollectionHelper.toSet(eligibleWampSessionIds)).build());
    }

    public <T> void publishTo(Collection<Long> eligibleWampSessionIds, String topic, @Nullable Map<String, T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(arguments).eligible(CollectionHelper.toSet(eligibleWampSessionIds)).build());
    }

    public <T> void publishTo(long eligibleWampSessionId, String topic, T ... arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).addEligible(eligibleWampSessionId).build());
    }

    public <T> void publishTo(long eligibleWampSessionId, String topic, @Nullable Collection<T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).addEligible(eligibleWampSessionId).build());
    }

    public <T> void publishTo(long eligibleWampSessionId, String topic, @Nullable Map<String, T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(arguments).addEligible(eligibleWampSessionId).build());
    }

    public <T> void publishToAllExcept(Collection<Long> excludeWampSessionIds, String topic, T ... arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).exclude(CollectionHelper.toSet(excludeWampSessionIds)).build());
    }

    public <T> void publishToAllExcept(Collection<Long> excludeWampSessionIds, String topic, @Nullable Collection<T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).exclude(CollectionHelper.toSet(excludeWampSessionIds)).build());
    }

    public <T> void publishToAllExcept(Collection<Long> excludeWampSessionIds, String topic, @Nullable Map<String, T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(arguments).exclude(CollectionHelper.toSet(excludeWampSessionIds)).build());
    }

    public <T> void publishToAllExcept(long excludeWampSessionId, String topic, T ... arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).addExclude(excludeWampSessionId).build());
    }

    public <T> void publishToAllExcept(long excludeWampSessionId, String topic, @Nullable Collection<T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(CollectionHelper.toList(arguments)).addExclude(excludeWampSessionId).build());
    }

    public <T> void publishToAllExcept(long excludeWampSessionId, String topic, @Nullable Map<String, T> arguments) {
        this.publish(this.publishMessageBuilder(topic).arguments(arguments).addExclude(excludeWampSessionId).build());
    }

    public PublishMessage.Builder publishMessageBuilder(String topic) {
        long requestId = IdGenerator.newLinearId(this.atomicLong);
        return PublishMessage.builder(requestId, topic);
    }
}

