/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.servlet;

import ch.rasc.wamp2spring.config.WampConfiguration;
import ch.rasc.wamp2spring.config.WampConfigurer;
import ch.rasc.wamp2spring.servlet.EnableServletWamp;
import ch.rasc.wamp2spring.servlet.PreferBinaryHandshakeHandler;
import ch.rasc.wamp2spring.servlet.WampServletConfigurer;
import ch.rasc.wamp2spring.servlet.WampSubProtocolHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.ServletWebSocketHandlerRegistry;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.HandshakeHandler;

@Configuration
public class WampServletConfiguration
extends WampConfiguration
implements ImportAware {
    @Nullable
    private ServletWebSocketHandlerRegistry handlerRegistry;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        super.setImportMetadata(importMetadata, EnableServletWamp.class.getName());
    }

    @Bean
    public SubProtocolWebSocketHandler subProtocolWebSocketHandler() {
        SubProtocolWebSocketHandler subProtocolWebSocketHandler = new SubProtocolWebSocketHandler((MessageChannel)this.clientInboundChannel(), this.clientOutboundChannel());
        subProtocolWebSocketHandler.addProtocolHandler((SubProtocolHandler)this.wampSubProtocolHandler());
        return subProtocolWebSocketHandler;
    }

    @Bean
    public WampSubProtocolHandler wampSubProtocolHandler() {
        return new WampSubProtocolHandler(this.jsonJsonFactory(), this.msgpackJsonFactory(), this.cborJsonFactory(), this.smileJsonFactory(), (MessageChannel)this.clientInboundChannel(), this.features);
    }

    @Bean
    public HandlerMapping webSocketHandlerMapping() {
        ServletWebSocketHandlerRegistry registry = this.initHandlerRegistry();
        return registry.getHandlerMapping();
    }

    private ServletWebSocketHandlerRegistry initHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new ServletWebSocketHandlerRegistry();
            this.registerWebSocketHandlers((WebSocketHandlerRegistry)this.handlerRegistry);
        }
        return this.handlerRegistry;
    }

    protected void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        Integer sendBufferSizeLimit;
        SubProtocolWebSocketHandler subProtocolWebSocketHandler = this.subProtocolWebSocketHandler();
        Integer sendTimeLimit = this.getSendTimeLimit();
        if (sendTimeLimit != null) {
            subProtocolWebSocketHandler.setSendTimeLimit(sendTimeLimit.intValue());
        }
        if ((sendBufferSizeLimit = this.getSendBufferSizeLimit()) != null) {
            subProtocolWebSocketHandler.setSendBufferSizeLimit(sendBufferSizeLimit.intValue());
        }
        SubProtocolWebSocketHandler decoratedHandler = subProtocolWebSocketHandler;
        decoratedHandler = this.decorateWebSocketHandler((WebSocketHandler)decoratedHandler);
        for (WampConfigurer wc : this.configurers) {
            if (!(wc instanceof WampServletConfigurer)) continue;
            decoratedHandler = ((WampServletConfigurer)wc).decorateWebSocketHandler((WebSocketHandler)decoratedHandler);
        }
        WebSocketHandlerRegistration registration = registry.addHandler((WebSocketHandler)decoratedHandler, new String[]{this.getWebSocketHandlerPath()});
        registration.setHandshakeHandler(this.getHandshakeHandler());
        this.configureWebSocketHandlerRegistration(registration);
        for (WampConfigurer wc : this.configurers) {
            if (!(wc instanceof WampServletConfigurer)) continue;
            ((WampServletConfigurer)wc).configureWebSocketHandlerRegistration(registration);
        }
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        return handler;
    }

    protected void configureWebSocketHandlerRegistration(WebSocketHandlerRegistration registration) {
    }

    protected HandshakeHandler getHandshakeHandler() {
        return new PreferBinaryHandshakeHandler();
    }

    @Nullable
    protected Integer getSendTimeLimit() {
        return null;
    }

    @Nullable
    protected Integer getSendBufferSizeLimit() {
        return null;
    }
}

