/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.security;

import ch.rasc.wamp2spring.config.WampConfigurer;
import ch.rasc.wamp2spring.message.WampMessageHeader;
import ch.rasc.wamp2spring.security.WampMessageSecurityMetadataSourceRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.messaging.access.expression.DefaultMessageSecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.MessageExpressionVoter;
import org.springframework.security.messaging.access.intercept.ChannelSecurityInterceptor;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.context.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.messaging.context.SecurityContextChannelInterceptor;

public abstract class AbstractSecurityWampConfigurer
implements WampConfigurer {
    private SecurityExpressionHandler<Message<Object>> defaultExpressionHandler = new DefaultMessageSecurityExpressionHandler();
    @Nullable
    private SecurityExpressionHandler<Message<Object>> expressionHandler;
    private final WampMessageSecurityMetadataSourceRegistry inboundRegistry = new WampMessageSecurityMetadataSourceRegistry();

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver());
    }

    public void configureClientInboundChannel(AbstractMessageChannel channel) {
        ChannelSecurityInterceptor inboundChannelSecurity = this.inboundChannelSecurity();
        channel.addInterceptor((ChannelInterceptor)this.securityContextChannelInterceptor());
        if (this.inboundRegistry.containsMapping()) {
            channel.addInterceptor((ChannelInterceptor)inboundChannelSecurity);
        }
    }

    @Bean
    public ChannelSecurityInterceptor inboundChannelSecurity() {
        ChannelSecurityInterceptor channelSecurityInterceptor = new ChannelSecurityInterceptor(this.inboundMessageSecurityMetadataSource());
        MessageExpressionVoter voter = new MessageExpressionVoter();
        voter.setExpressionHandler(this.getMessageExpressionHandler());
        ArrayList<MessageExpressionVoter> voters = new ArrayList<MessageExpressionVoter>();
        voters.add(voter);
        AffirmativeBased manager = new AffirmativeBased(voters);
        channelSecurityInterceptor.setAccessDecisionManager((AccessDecisionManager)manager);
        return channelSecurityInterceptor;
    }

    @Bean
    public SecurityContextChannelInterceptor securityContextChannelInterceptor() {
        return new SecurityContextChannelInterceptor(WampMessageHeader.PRINCIPAL.name());
    }

    @Bean
    public MessageSecurityMetadataSource inboundMessageSecurityMetadataSource() {
        this.inboundRegistry.expressionHandler(this.getMessageExpressionHandler());
        this.configureInbound(this.inboundRegistry);
        return this.inboundRegistry.createMetadataSource();
    }

    protected void configureInbound(WampMessageSecurityMetadataSourceRegistry messages) {
    }

    @Autowired(required=false)
    public void setMessageExpressionHandler(List<SecurityExpressionHandler<Message<Object>>> expressionHandlers) {
        if (expressionHandlers.size() == 1) {
            this.expressionHandler = expressionHandlers.get(0);
        }
    }

    @Autowired(required=false)
    public void setObjectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        this.defaultExpressionHandler = (SecurityExpressionHandler)objectPostProcessor.postProcess(this.defaultExpressionHandler);
    }

    private SecurityExpressionHandler<Message<Object>> getMessageExpressionHandler() {
        if (this.expressionHandler == null) {
            return this.defaultExpressionHandler;
        }
        return this.expressionHandler;
    }
}

