/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.security.matcher;

import ch.rasc.wamp2spring.config.DestinationMatch;
import ch.rasc.wamp2spring.message.SubscribeMessage;
import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import org.springframework.messaging.Message;
import org.springframework.security.messaging.util.matcher.MessageMatcher;

public class WampSubscribeMessageMatcher
implements MessageMatcher<Object> {
    private final DestinationMatch topicMatch;

    public WampSubscribeMessageMatcher(DestinationMatch topicMatch) {
        this.topicMatch = topicMatch;
    }

    public boolean matches(Message<? extends Object> message) {
        if (message instanceof SubscribeMessage) {
            SubscribeMessage subscribeMessage = (SubscribeMessage)message;
            String topic = subscribeMessage.getTopic();
            if (this.topicMatch.getMatchPolicy() != MatchPolicy.PREFIX) {
                return subscribeMessage.getMatchPolicy() == this.topicMatch.getMatchPolicy() && topic.equals(this.topicMatch.getDestination());
            }
            return topic.startsWith(this.topicMatch.getDestination());
        }
        return false;
    }
}

