/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.security.matcher;

import ch.rasc.wamp2spring.message.WampMessage;
import org.springframework.messaging.Message;
import org.springframework.security.messaging.util.matcher.MessageMatcher;

public class WampMessageMatcher
implements MessageMatcher<Object> {
    private final int code;

    public WampMessageMatcher(int code) {
        this.code = code;
    }

    public boolean matches(Message<? extends Object> message) {
        if (message instanceof WampMessage) {
            return ((WampMessage)message).getCode() == this.code;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WampMessageMatcher other = (WampMessageMatcher)obj;
        return this.code == other.code;
    }

    public String toString() {
        return "WampMessageMatcher [code=" + this.code + "]";
    }
}

