/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.security;

import ch.rasc.wamp2spring.config.DestinationMatch;
import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import ch.rasc.wamp2spring.security.matcher.WampCallMessageMatcher;
import ch.rasc.wamp2spring.security.matcher.WampMessageMatcher;
import ch.rasc.wamp2spring.security.matcher.WampPublishMessageMatcher;
import ch.rasc.wamp2spring.security.matcher.WampRegisterMessageMatcher;
import ch.rasc.wamp2spring.security.matcher.WampSubscribeMessageMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.DefaultMessageSecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.ExpressionBasedMessageSecurityMetadataSourceFactory;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WampMessageSecurityMetadataSourceRegistry {
    private SecurityExpressionHandler<Message<Object>> expressionHandler = new DefaultMessageSecurityExpressionHandler();
    final LinkedHashMap<MessageMatcher<?>, String> matcherToExpression = new LinkedHashMap();

    public Constraint anyMessage() {
        return this.matchers(MessageMatcher.ANY_MESSAGE);
    }

    public Constraint registerMessage() {
        return this.matchers(new WampMessageMatcher(64));
    }

    public Constraint callMessage() {
        return this.matchers(new WampMessageMatcher(48));
    }

    public Constraint subscribeMessage() {
        return this.matchers(new WampMessageMatcher(32));
    }

    public Constraint publishMessage() {
        return this.matchers(new WampMessageMatcher(16));
    }

    public Constraint registerMessage(DestinationMatch ... destinationMatches) {
        if (destinationMatches != null && destinationMatches.length > 0) {
            ArrayList messageMatchers = new ArrayList();
            for (DestinationMatch destinationMatch : destinationMatches) {
                messageMatchers.add(new WampRegisterMessageMatcher(destinationMatch));
            }
            return new Constraint(messageMatchers);
        }
        return this.registerMessage();
    }

    public Constraint registerMessage(String ... procedures) {
        if (procedures != null && procedures.length > 0) {
            ArrayList<DestinationMatch> destionationMatches = new ArrayList<DestinationMatch>();
            for (String procedure : procedures) {
                destionationMatches.add(new DestinationMatch(procedure, MatchPolicy.EXACT));
            }
            return this.registerMessage(destionationMatches.toArray(new DestinationMatch[destionationMatches.size()]));
        }
        return this.registerMessage();
    }

    public Constraint callMessage(DestinationMatch ... destinationMatches) {
        if (destinationMatches != null && destinationMatches.length > 0) {
            ArrayList messageMatchers = new ArrayList();
            for (DestinationMatch destinationMatch : destinationMatches) {
                messageMatchers.add(new WampCallMessageMatcher(destinationMatch));
            }
            return new Constraint(messageMatchers);
        }
        return this.callMessage();
    }

    public Constraint callMessage(String ... procedures) {
        if (procedures != null && procedures.length > 0) {
            ArrayList<DestinationMatch> destionationMatches = new ArrayList<DestinationMatch>();
            for (String procedure : procedures) {
                destionationMatches.add(new DestinationMatch(procedure, MatchPolicy.EXACT));
            }
            return this.callMessage(destionationMatches.toArray(new DestinationMatch[destionationMatches.size()]));
        }
        return this.callMessage();
    }

    public Constraint subscribeMessage(DestinationMatch ... destinationMatches) {
        if (destinationMatches != null && destinationMatches.length > 0) {
            ArrayList messageMatchers = new ArrayList();
            for (DestinationMatch destinationMatch : destinationMatches) {
                messageMatchers.add(new WampSubscribeMessageMatcher(destinationMatch));
            }
            return new Constraint(messageMatchers);
        }
        return this.subscribeMessage();
    }

    public Constraint subscribeMessage(String ... topics) {
        if (topics != null && topics.length > 0) {
            ArrayList<DestinationMatch> destionationMatches = new ArrayList<DestinationMatch>();
            for (String topic : topics) {
                destionationMatches.add(new DestinationMatch(topic, MatchPolicy.EXACT));
            }
            return this.subscribeMessage(destionationMatches.toArray(new DestinationMatch[destionationMatches.size()]));
        }
        return this.subscribeMessage();
    }

    public Constraint publishMessage(DestinationMatch ... destinationMatches) {
        if (destinationMatches != null && destinationMatches.length > 0) {
            ArrayList messageMatchers = new ArrayList();
            for (DestinationMatch destinationMatch : destinationMatches) {
                messageMatchers.add(new WampPublishMessageMatcher(destinationMatch));
            }
            return new Constraint(messageMatchers);
        }
        return this.publishMessage();
    }

    public Constraint publishMessage(String ... topics) {
        if (topics != null && topics.length > 0) {
            ArrayList<DestinationMatch> destionationMatches = new ArrayList<DestinationMatch>();
            for (String topic : topics) {
                destionationMatches.add(new DestinationMatch(topic, MatchPolicy.EXACT));
            }
            return this.publishMessage(destionationMatches.toArray(new DestinationMatch[destionationMatches.size()]));
        }
        return this.publishMessage();
    }

    public Constraint topicMatchers(DestinationMatch ... topicMatches) {
        if (topicMatches != null && topicMatches.length > 0) {
            ArrayList messageMatchers = new ArrayList();
            for (DestinationMatch destinationMatch : topicMatches) {
                messageMatchers.add(new WampSubscribeMessageMatcher(destinationMatch));
                messageMatchers.add(new WampPublishMessageMatcher(destinationMatch));
            }
            return new Constraint(messageMatchers);
        }
        return this.publishMessage();
    }

    public Constraint procedureMatchers(DestinationMatch ... procedureMatches) {
        if (procedureMatches != null && procedureMatches.length > 0) {
            ArrayList messageMatchers = new ArrayList();
            for (DestinationMatch destinationMatch : procedureMatches) {
                messageMatchers.add(new WampRegisterMessageMatcher(destinationMatch));
                messageMatchers.add(new WampCallMessageMatcher(destinationMatch));
            }
            return new Constraint(messageMatchers);
        }
        return this.callMessage();
    }

    public Constraint matchers(MessageMatcher<?> ... matchers) {
        return new Constraint(Arrays.asList(matchers));
    }

    public void expressionHandler(SecurityExpressionHandler<Message<Object>> exprHandler) {
        this.expressionHandler = exprHandler;
    }

    public MessageSecurityMetadataSource createMetadataSource() {
        return ExpressionBasedMessageSecurityMetadataSourceFactory.createExpressionMessageMetadataSource(this.matcherToExpression, this.expressionHandler);
    }

    public boolean containsMapping() {
        return !this.matcherToExpression.isEmpty();
    }

    public class Constraint {
        private final List<MessageMatcher<?>> messageMatchers;

        Constraint(List<MessageMatcher<?>> messageMatchers) {
            this.messageMatchers = messageMatchers;
        }

        public WampMessageSecurityMetadataSourceRegistry hasRole(String role) {
            return this.access(this.hasRoleBuilder(role));
        }

        public WampMessageSecurityMetadataSourceRegistry hasAnyRole(String ... roles) {
            return this.access(this.hasAnyRoleBuilder(roles));
        }

        public WampMessageSecurityMetadataSourceRegistry hasAuthority(String authority) {
            return this.access(this.hasAuthorityBuilder(authority));
        }

        public WampMessageSecurityMetadataSourceRegistry hasAnyAuthority(String ... authorities) {
            return this.access(this.hasAnyAuthorityBuilder(authorities));
        }

        public WampMessageSecurityMetadataSourceRegistry permitAll() {
            return this.access("permitAll");
        }

        public WampMessageSecurityMetadataSourceRegistry anonymous() {
            return this.access("anonymous");
        }

        public WampMessageSecurityMetadataSourceRegistry rememberMe() {
            return this.access("rememberMe");
        }

        public WampMessageSecurityMetadataSourceRegistry denyAll() {
            return this.access("denyAll");
        }

        public WampMessageSecurityMetadataSourceRegistry authenticated() {
            return this.access("authenticated");
        }

        public WampMessageSecurityMetadataSourceRegistry fullyAuthenticated() {
            return this.access("fullyAuthenticated");
        }

        public WampMessageSecurityMetadataSourceRegistry access(String attribute) {
            for (MessageMatcher<?> messageMatcher : this.messageMatchers) {
                WampMessageSecurityMetadataSourceRegistry.this.matcherToExpression.put(messageMatcher, attribute);
            }
            return WampMessageSecurityMetadataSourceRegistry.this;
        }

        private String hasAnyRoleBuilder(String ... authorities) {
            String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','ROLE_");
            return "hasAnyRole('ROLE_" + anyAuthorities + "')";
        }

        private String hasRoleBuilder(String role) {
            Assert.notNull((Object)role, (String)"role cannot be null");
            if (role.startsWith("ROLE_")) {
                throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
            }
            return "hasRole('ROLE_" + role + "')";
        }

        private String hasAuthorityBuilder(String authority) {
            return "hasAuthority('" + authority + "')";
        }

        private String hasAnyAuthorityBuilder(String ... authorities) {
            String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','");
            return "hasAnyAuthority('" + anyAuthorities + "')";
        }
    }
}

